/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.AbstractSchemesManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.options.SchemesManagerImpl;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SchemesManagerFactoryImpl
extends SchemesManagerFactory
implements SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.SchemesManagerFactoryImpl");
    private final Collection<SchemesManagerImpl> myRegisteredManagers = new ArrayList<SchemesManagerImpl>();

    public <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(String fileSpec, SchemeProcessor<E> processor, RoamingType roamingType) {
        Application application = ApplicationManager.getApplication();
        if (!(application instanceof ApplicationImpl)) {
            return null;
        }
        String baseDirPath = ((ApplicationImpl)application).getStateStore().getStateStorageManager().expandMacroses(fileSpec);
        if (baseDirPath != null) {
            SchemesManagerImpl manager = new SchemesManagerImpl(fileSpec, processor, roamingType, ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(roamingType), new File(baseDirPath));
            this.myRegisteredManagers.add(manager);
            return manager;
        }
        return new AbstractSchemesManager<T, E>(){

            @NotNull
            public Collection<E> loadSchemes() {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/options/SchemesManagerFactoryImpl$1.loadSchemes must not return null");
                }
                return list;
            }

            @NotNull
            public Collection<SharedScheme<E>> loadSharedSchemes(Collection<T> currentSchemeList) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/options/SchemesManagerFactoryImpl$1.loadSharedSchemes must not return null");
                }
                return list;
            }

            public void exportScheme(E scheme, String name, String description) throws WriteExternalException {
            }

            public boolean isImportAvailable() {
                return false;
            }

            public boolean isShared(Scheme scheme) {
                return false;
            }

            @Override
            public void save() throws WriteExternalException {
            }

            @Override
            protected void onSchemeDeleted(Scheme toDelete) {
            }

            @Override
            protected void onSchemeAdded(T scheme) {
            }

            public boolean isExportAvailable() {
                return false;
            }

            public File getRootDirectory() {
                return null;
            }
        };
    }

    public void updateConfigFilesFromStreamProviders() {
        for (SchemesManagerImpl registeredManager : this.myRegisteredManagers) {
            try {
                registeredManager.updateConfigFilesFromStreamProviders();
            }
            catch (Throwable e) {
                LOG.info("Cannot save settings for " + registeredManager.getClass().getName(), e);
            }
        }
    }

    public void save() {
        for (SchemesManagerImpl registeredManager : this.myRegisteredManagers) {
            try {
                registeredManager.save();
            }
            catch (Throwable e) {
                LOG.info("Cannot save settings for " + registeredManager.getClass().getName(), e);
            }
        }
    }
}

