/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.binding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.binding.BeanValueAccessor;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.ControlValueAccessor;
import com.intellij.openapi.options.binding.ValueAccessor;
import com.intellij.openapi.options.binding.ValueTypeConverter;
import com.intellij.openapi.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ControlBinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.binding.ControlBinder");
    private final Object myBean;
    private final List<Pair<ControlValueAccessor, BeanValueAccessor>> myBindings = new ArrayList<Pair<ControlValueAccessor, BeanValueAccessor>>();

    public ControlBinder(Object bean) {
        this.myBean = bean;
    }

    public void bindControl(JComponent control, String propertyName, boolean instant) {
        ControlValueAccessor controlAccessor;
        if (control instanceof JCheckBox) {
            controlAccessor = ValueAccessor.checkBoxAccessor((JCheckBox)control);
        } else if (control instanceof JTextField) {
            controlAccessor = ValueAccessor.textFieldAccessor((JTextField)control);
        } else {
            throw new IllegalArgumentException("Cannot bind control of type " + control.getClass() + ".\n" + "Use bindControl(ControlValueAccessor, String) instead.");
        }
        this.bindControl(controlAccessor, propertyName, instant);
    }

    public void bindControl(ControlValueAccessor controlAccessor, String propertyName, boolean instant) {
        BeanValueAccessor beanAccessor = BeanValueAccessor.createAccessor(this.myBean, propertyName);
        final Pair binding = Pair.create((Object)controlAccessor, (Object)beanAccessor);
        this.myBindings.add((Pair<ControlValueAccessor, BeanValueAccessor>)binding);
        if (instant) {
            controlAccessor.addChangeListener(new Runnable(){

                @Override
                public void run() {
                    ControlBinder.this.apply((Pair<ControlValueAccessor, BeanValueAccessor>)binding);
                }
            });
        }
    }

    public void reset() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            if (!((ControlValueAccessor)binding.first).isEnabled()) continue;
            Object value = ((BeanValueAccessor)binding.second).getValue();
            try {
                value = this.convert(value, ((ControlValueAccessor)binding.first).getType());
                ((ControlValueAccessor)binding.first).setValue(value);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void apply() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            this.apply(binding);
        }
    }

    private void apply(Pair<ControlValueAccessor, BeanValueAccessor> binding) {
        if (!((ControlValueAccessor)binding.first).isEnabled()) {
            return;
        }
        Object value = ((ControlValueAccessor)binding.first).getValue();
        try {
            value = this.convert(value, ((BeanValueAccessor)binding.second).getType());
            ((BeanValueAccessor)binding.second).setValue(value);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
    }

    public boolean isModified() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            if (!((ControlValueAccessor)binding.first).isEnabled()) continue;
            Object value = ((ControlValueAccessor)binding.first).getValue();
            try {
                if ((value = this.convert(value, ((BeanValueAccessor)binding.second).getType())).equals(((BeanValueAccessor)binding.second).getValue())) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
        return false;
    }

    protected Object convert(Object value, Class to) {
        Class<?> from = value.getClass();
        if (!to.isAssignableFrom(from)) {
            if (to.isPrimitive() && to.equals(Integer.TYPE)) {
                to = Integer.class;
            }
            for (ValueTypeConverter converter : ValueTypeConverter.STANDARD) {
                if (from.equals(converter.getSourceType()) && to.equals(converter.getTargetType())) {
                    return converter.from(value);
                }
                if (!to.equals(converter.getSourceType()) || !from.equals(converter.getTargetType())) continue;
                return converter.to(value);
            }
        }
        return value;
    }

    public void bindAnnotations(Object form) {
        Field[] fields;
        for (Field field : fields = form.getClass().getDeclaredFields()) {
            BindControl annotation = field.getAnnotation(BindControl.class);
            if (annotation == null) continue;
            String name = annotation.value();
            if (name.length() == 0) {
                name = field.getName();
            }
            try {
                field.setAccessible(true);
                this.bindControl((JComponent)field.get(form), name, annotation.instant());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

