/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
QuickFixProvider<PsiDynaReference>,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private int myChosenOne = -1;
    private ResolveResult[] myCachedResult;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<PsiReference> references) {
        this.myReferences.addAll(references);
        for (PsiReference reference : references) {
            if (reference.isSoft()) continue;
            this.mySoft = false;
        }
    }

    public List<PsiReference> getReferences() {
        return this.myReferences;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
        if (!reference.isSoft()) {
            this.mySoft = false;
        }
    }

    public TextRange getRangeInElement() {
        PsiReference resolved = null;
        PsiReference reference = this.myReferences.get(0);
        if (reference.resolve() != null) {
            resolved = reference;
        }
        TextRange range = reference.getRangeInElement();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        for (int i = 1; i < this.myReferences.size(); ++i) {
            reference = this.myReferences.get(i);
            TextRange textRange = this.getRange(reference);
            start = Math.min(start, textRange.getStartOffset());
            if (resolved != null) continue;
            end = Math.max(end, textRange.getEndOffset());
        }
        return new TextRange(start, end);
    }

    private TextRange getRange(PsiReference reference) {
        TextRange rangeInElement = reference.getRangeInElement();
        PsiElement element = reference.getElement();
        while (element != this.myElement) {
            rangeInElement = rangeInElement.shiftRight(element.getStartOffsetInParent());
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return rangeInElement;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public String getCanonicalText() {
        PsiReference reference = this.chooseReference();
        return reference == null ? this.myReferences.get(0).getCanonicalText() : reference.getCanonicalText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiReference reference = this.chooseReference();
        if (reference != null) {
            return reference.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PsiDynaReference.bindToElement must not be null");
        }
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReference)) continue;
            return reference.bindToElement(element);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PsiDynaReference.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        if (this.myCachedResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PsiDynaReference.multiResolve must not return null");
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (PsiReference reference : this.myReferences) {
            if (reference instanceof PsiPolyVariantReference) {
                for (ResolveResult rr : ((PsiPolyVariantReference)reference).multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            result.add(new PsiElementResolveResult(resolved));
        }
        return result.toArray(new ResolveResult[result.size()]);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myChosenOne != -1) {
            return this.myReferences.get(this.myChosenOne);
        }
        boolean flag = false;
        for (int i = 0; i < this.myReferences.size(); ++i) {
            PsiReference reference = this.myReferences.get(i);
            if (reference.isSoft() && flag) continue;
            if (!reference.isSoft() && !flag) {
                this.myChosenOne = i;
                flag = true;
                continue;
            }
            if (reference.resolve() == null) continue;
            this.myChosenOne = i;
        }
        return this.myChosenOne >= 0 ? this.myReferences.get(this.myChosenOne) : null;
    }

    @Override
    public void registerQuickfix(HighlightInfo info, PsiDynaReference reference) {
        for (PsiReference ref : reference.myReferences) {
            if (!(ref instanceof QuickFixProvider)) continue;
            ((QuickFixProvider)ref).registerQuickfix(info, ref);
        }
    }

    public String getUnresolvedMessagePattern() {
        PsiReference reference = this.chooseReference();
        return reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList<LocalQuickFix> list = new ArrayList<LocalQuickFix>();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            list.addAll(Arrays.asList(((LocalQuickFixProvider)ref).getQuickFixes()));
        }
        return list.toArray(new LocalQuickFix[list.size()]);
    }

    public String toString() {
        return "PsiDynaReference containing " + this.myReferences.toString();
    }

    @Override
    public FileReference getLastFileReference() {
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReferenceOwner)) continue;
            return ((FileReferenceOwner)reference).getLastFileReference();
        }
        return null;
    }
}

