/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class DumbServiceImpl
extends DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private volatile boolean myDumb = false;
    private final DumbService.DumbModeListener myPublisher;
    private final Queue<IndexUpdateRunnable> myUpdatesQueue = new Queue(5);
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private static final Ref<CacheUpdateRunner> NULL_ACTION = new Ref(null);

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbServiceImpl.getInstance must not be null");
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public DumbServiceImpl(Project project, MessageBus bus) {
        this.myProject = project;
        this.myPublisher = (DumbService.DumbModeListener)bus.syncPublisher(DUMB_MODE);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isDumb() {
        return this.myDumb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenSmart(Runnable runnable) {
        if (!this.isDumb()) {
            runnable.run();
        } else {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myRunWhenSmartQueue.addLast((Object)runnable);
            }
        }
    }

    public void queueCacheUpdate(Collection<CacheUpdater> updaters) {
        this.scheduleCacheUpdate(updaters, false);
    }

    public void queueCacheUpdateInDumbMode(Collection<CacheUpdater> updaters) {
        this.scheduleCacheUpdate(updaters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCacheUpdate(Collection<CacheUpdater> updaters, boolean forceDumbMode) {
        Application application;
        CacheUpdateRunner runner;
        block11: {
            runner = new CacheUpdateRunner(this.myProject, new ArrayList<CacheUpdater>(updaters));
            application = ApplicationManager.getApplication();
            if (!forceDumbMode && !this.myDumb && application.isReadAccessAllowed()) {
                ProgressIndicator indicator;
                ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (currentIndicator != null) {
                    indicator = currentIndicator;
                    currentIndicator.pushState();
                } else {
                    indicator = new EmptyProgressIndicator();
                }
                try {
                    int size = runner.queryNeededFiles(indicator);
                    if (!application.isHeadlessEnvironment() && size + runner.getNumberOfPendingUpdateJobs(indicator) >= 50) break block11;
                    try {
                        HeavyProcessLatch.INSTANCE.processStarted();
                        if (size > 0) {
                            runner.processFiles(indicator, false);
                        }
                        runner.updatingDone();
                    }
                    finally {
                        HeavyProcessLatch.INSTANCE.processFinished();
                    }
                    return;
                }
                finally {
                    if (currentIndicator != null) {
                        currentIndicator.popState();
                    }
                }
            }
        }
        final IndexUpdateRunnable updateRunnable = new IndexUpdateRunnable(runner);
        DumbServiceImpl.invokeOnEDT(new DumbAwareRunnable(){

            public void run() {
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean wasDumb = DumbServiceImpl.this.myDumb;
                if (!wasDumb) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            DumbServiceImpl.this.myDumb = true;
                            DumbServiceImpl.this.myPublisher.enteredDumbMode();
                            updateRunnable.run();
                        }
                    });
                } else {
                    DumbServiceImpl.this.myUpdatesQueue.addLast((Object)updateRunnable);
                }
            }
        });
    }

    private static void invokeOnEDT(DumbAwareRunnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater((Runnable)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        this.myDumb = false;
        this.myPublisher.exitDumbMode();
        while (true) {
            Runnable runnable;
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                if (this.myRunWhenSmartQueue.isEmpty()) {
                    break;
                }
                runnable = (Runnable)this.myRunWhenSmartQueue.pullFirst();
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            runnable.run();
        }
    }

    public BalloonHandler showDumbModeNotification(String message) {
        BalloonHandler emptyBalloonHandler = new BalloonHandler(){

            public void hide() {
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return emptyBalloonHandler;
        }
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (ideFrame == null) {
            return emptyBalloonHandler;
        }
        StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                Messages.showMessageDialog((String)("<html>" + ApplicationNamesInfo.getInstance().getFullProductName() + " is now indexing project sources and libraries to enable advanced features <br>" + "(refactorings, navigation, usage search, code analysis, formatting, etc.)<br>" + "During this process you can use code editor and VCS integrations,<br>" + "and adjust IDE and Run Configurations settings." + "</html>"), (String)"Don't panic!", null);
            }
        };
        return statusBar.notifyProgressByBalloon(MessageType.WARNING, message, null, listener);
    }

    public void waitForSmartMode() {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            assert (!application.isDispatchThread());
            assert (!application.isReadAccessAllowed());
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.runWhenSmart(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }

    private class IndexUpdateRunnable
    implements Runnable {
        private final CacheUpdateRunner myAction;
        private double myProcessedItems;
        private volatile int myTotalItems;
        private double myCurrentBaseTotal;

        public IndexUpdateRunnable(CacheUpdateRunner action) {
            this.myAction = action;
            this.myTotalItems = 0;
            this.myCurrentBaseTotal = 0.0;
        }

        @Override
        public void run() {
            if (DumbServiceImpl.this.myProject.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(DumbServiceImpl.this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){
                private final ArrayBlockingQueue<Ref<CacheUpdateRunner>> myActionQueue;
                {
                    this.myActionQueue = new ArrayBlockingQueue(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbServiceImpl$IndexUpdateRunnable$1.run must not be null");
                    }
                    ProgressIndicator proxy = (ProgressIndicator)Proxy.newProxyInstance(indicator.getClass().getClassLoader(), new Class[]{ProgressIndicator.class}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if ("setFraction".equals(method.getName())) {
                                double fraction = (Double)args[0];
                                args[0] = new Double((IndexUpdateRunnable.this.myProcessedItems + fraction * IndexUpdateRunnable.this.myCurrentBaseTotal) / (double)IndexUpdateRunnable.this.myTotalItems);
                            }
                            try {
                                return method.invoke((Object)indicator, args);
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof ProcessCanceledException) {
                                    throw cause;
                                }
                                throw e;
                            }
                        }
                    });
                    try {
                        HeavyProcessLatch.INSTANCE.processStarted();
                        this.runAction(proxy, IndexUpdateRunnable.this.myAction);
                    }
                    finally {
                        HeavyProcessLatch.INSTANCE.processFinished();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                private void runAction(ProgressIndicator indicator, CacheUpdateRunner updateRunner) {
                    do {
                        int count = 0;
                        indicator.setIndeterminate(true);
                        indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                        count = updateRunner.queryNeededFiles(indicator);
                        IndexUpdateRunnable.this.myCurrentBaseTotal = count;
                        IndexUpdateRunnable.this.myTotalItems += count;
                        indicator.setIndeterminate(false);
                        indicator.setText(IdeBundle.message((String)"progress.indexing.updaing", (Object[])new Object[0]));
                        updateRunner.processFiles(indicator, true);
                        updateRunner.updatingDone();
                        IndexUpdateRunnable.this.myProcessedItems += count;
                        DumbServiceImpl.invokeOnEDT(new DumbAwareRunnable(){

                            public void run() {
                                if (DumbServiceImpl.this.myUpdatesQueue.isEmpty()) {
                                    myActionQueue.offer(NULL_ACTION);
                                    DumbServiceImpl.this.updateFinished();
                                } else {
                                    IndexUpdateRunnable nextUpdateRunnable = (IndexUpdateRunnable)DumbServiceImpl.this.myUpdatesQueue.pullFirst();
                                    if (!myActionQueue.offer(new Ref((Object)nextUpdateRunnable.myAction))) {
                                        LOG.error("Action queue rejected next updateRunnable!");
                                        nextUpdateRunnable.run();
                                    }
                                }
                            }
                        });
                        try {
                            Ref<CacheUpdateRunner> ref;
                            do {
                                CacheUpdateRunner cacheUpdateRunner = updateRunner = (ref = this.myActionQueue.poll(500L, TimeUnit.MILLISECONDS)) != null ? (CacheUpdateRunner)ref.get() : null;
                            } while (!this.myProject.isDisposed() && ref == null);
                            continue;
                        }
                        catch (InterruptedException ignored) {
                            LOG.info((Throwable)ignored);
                            break;
                        }
                        catch (Throwable throwable) {
                            IndexUpdateRunnable.this.myProcessedItems += count;
                            DumbServiceImpl.invokeOnEDT(new /* invalid duplicate definition of identical inner class */);
                            try {
                                Ref<CacheUpdateRunner> ref;
                                do {
                                    CacheUpdateRunner cacheUpdateRunner = updateRunner = (ref = this.myActionQueue.poll(500L, TimeUnit.MILLISECONDS)) != null ? (CacheUpdateRunner)ref.get() : null;
                                } while (!this.myProject.isDisposed() && ref == null);
                            }
                            catch (InterruptedException ignored) {
                                LOG.info((Throwable)ignored);
                                break;
                            }
                            throw throwable;
                        }
                    } while (updateRunner != null);
                    this.myActionQueue.offer((Ref<CacheUpdateRunner>)NULL_ACTION);
                }
            });
        }
    }
}

