/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.util.ArrayList;

public class ExcludeCompilerOutputPolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;

    public ExcludeCompilerOutputPolicy(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean isExcludeRoot(VirtualFile f) {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        if (ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(f, compilerProjectExtension.getCompilerOutput(), compilerProjectExtension.getCompilerOutputUrl())) {
            return true;
        }
        for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            CompilerModuleExtension rm = CompilerModuleExtension.getInstance((Module)m);
            if (ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(f, rm.getCompilerOutputPath(), rm.getCompilerOutputUrl())) {
                return true;
            }
            if (!ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(f, rm.getCompilerOutputPathForTests(), rm.getCompilerOutputUrlForTests())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExcludeRootForModule(Module module, VirtualFile excludeRoot) {
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
        return compilerModuleExtension.getCompilerOutputPath() == excludeRoot || compilerModuleExtension.getCompilerOutputPathForTests() == excludeRoot;
    }

    @Override
    public VirtualFile[] getExcludeRootsForProject() {
        VirtualFile outputPath = CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutput();
        if (outputPath != null) {
            return new VirtualFile[]{outputPath};
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public VirtualFilePointer[] getExcludeRootsForModule(ModuleRootModel rootModel) {
        ArrayList<VirtualFilePointer> result = new ArrayList<VirtualFilePointer>();
        CompilerModuleExtension extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        if (extension.isCompilerOutputPathInherited()) {
            result.add(CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutputPointer());
        } else {
            VirtualFilePointer outputPathForTests;
            if (!extension.isExcludeOutput()) {
                return VirtualFilePointer.EMPTY_ARRAY;
            }
            VirtualFilePointer outputPath = extension.getCompilerOutputPointer();
            if (outputPath != null) {
                result.add(outputPath);
            }
            if ((outputPathForTests = extension.getCompilerOutputForTestsPointer()) != null) {
                result.add(outputPathForTests);
            }
        }
        return result.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : result.toArray(new VirtualFilePointer[result.size()]);
    }

    private static boolean isEqualWithFileOrUrl(VirtualFile f, VirtualFile fileToCompareWith, String url) {
        return fileToCompareWith != null ? fileToCompareWith == f : url != null && FileUtil.pathsEqual((String)url, (String)f.getUrl());
    }
}

