/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class LanguageLevelProjectExtensionImpl
extends LanguageLevelProjectExtension {
    @Deprecated
    @NonNls
    private static final String ASSERT_KEYWORD_ATTR = "assert-keyword";
    @Deprecated
    @NonNls
    private static final String JDK_15_ATTR = "jdk-15";
    private LanguageLevel myLanguageLevel;
    private LanguageLevel myOriginalLanguageLevel;
    private final Project myProject;
    private volatile Runnable myReloadProjectRequest;

    public LanguageLevelProjectExtensionImpl(Project project) {
        this.myOriginalLanguageLevel = this.myLanguageLevel = LanguageLevel.JDK_1_5;
        this.myProject = project;
    }

    private void readExternal(Element element) {
        String level = element.getAttributeValue("languageLevel");
        this.myLanguageLevel = level == null ? LanguageLevelProjectExtensionImpl.migrateFromIdea7(element) : LanguageLevel.valueOf((String)level);
        this.myOriginalLanguageLevel = this.myLanguageLevel;
    }

    private static LanguageLevel migrateFromIdea7(Element element) {
        boolean assertKeyword = Boolean.valueOf(element.getAttributeValue(ASSERT_KEYWORD_ATTR));
        boolean jdk15 = Boolean.valueOf(element.getAttributeValue(JDK_15_ATTR));
        if (jdk15) {
            return LanguageLevel.JDK_1_5;
        }
        if (assertKeyword) {
            return LanguageLevel.JDK_1_4;
        }
        return LanguageLevel.JDK_1_3;
    }

    private void writeExternal(Element element) {
        element.setAttribute("languageLevel", this.myLanguageLevel.name());
        this.writeAttributesForIdea7(element);
    }

    private void writeAttributesForIdea7(Element element) {
        boolean is14 = LanguageLevel.JDK_1_4.equals((Object)this.myLanguageLevel);
        boolean is15 = this.myLanguageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0;
        element.setAttribute(ASSERT_KEYWORD_ATTR, Boolean.toString(is14 || is15));
        element.setAttribute(JDK_15_ATTR, Boolean.toString(is15));
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        if (this.myLanguageLevel != languageLevel) {
            this.reloadProjectOnLanguageLevelChange(languageLevel, false);
        }
        this.myLanguageLevel = languageLevel;
        if (!this.willReload() && DirectoryIndex.getInstance(this.myProject).isInitialized()) {
            JavaLanguageLevelPusher.pushLanguageLevel(this.myProject);
        }
    }

    public void reloadProjectOnLanguageLevelChange(LanguageLevel languageLevel, final boolean forceReload) {
        if (this.willReload()) {
            this.myReloadProjectRequest = new Runnable(){

                @Override
                public void run() {
                    if (LanguageLevelProjectExtensionImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    if (LanguageLevelProjectExtensionImpl.this.myReloadProjectRequest != this) {
                        return;
                    }
                    if (!forceReload && LanguageLevelProjectExtensionImpl.this.myOriginalLanguageLevel.equals((Object)LanguageLevelProjectExtensionImpl.this.getLanguageLevel())) {
                        return;
                    }
                    String _message = ProjectBundle.message((String)"project.language.level.reload.prompt", (Object[])new Object[]{LanguageLevelProjectExtensionImpl.this.myProject.getName()});
                    if (Messages.showYesNoDialog((Project)LanguageLevelProjectExtensionImpl.this.myProject, (String)_message, (String)ProjectBundle.message((String)"project.language.level.reload.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                        ProjectManager.getInstance().reloadProject(LanguageLevelProjectExtensionImpl.this.myProject);
                    }
                    LanguageLevelProjectExtensionImpl.this.myReloadProjectRequest = null;
                }
            };
            ApplicationManager.getApplication().invokeLater(this.myReloadProjectRequest, ModalityState.NON_MODAL);
        } else {
            this.myOriginalLanguageLevel = languageLevel;
        }
    }

    private boolean willReload() {
        return this.myProject.isOpen() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final Project myProject;

        public MyProjectExtension(Project project) {
            this.myProject = project;
        }

        public void readExternal(Element element) throws InvalidDataException {
            ((LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)this.myProject)).readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            ((LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)this.myProject)).writeExternal(element);
        }
    }
}

