/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleSourceOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    static final String ENTRY_TYPE = "sourceFolder";
    @NonNls
    private static final String ATTRIBUTE_FOR_TESTS = "forTests";

    ModuleSourceOrderEntryImpl(RootModelImpl rootModel) {
        super(rootModel);
    }

    ModuleSourceOrderEntryImpl(Element element, RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute("type", ENTRY_TYPE);
        element.setAttribute(ATTRIBUTE_FOR_TESTS, Boolean.FALSE.toString());
        rootElement.addContent(element);
    }

    public boolean isValid() {
        return !this.isDisposed();
    }

    @NotNull
    public Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl.getOwnerModule must not return null");
        }
        return module;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleSourceOrderEntry((ModuleSourceOrderEntry)this, initialValue);
    }

    public String getPresentableName() {
        return ProjectBundle.message((String)"project.root.module.source", (Object[])new Object[0]);
    }

    void addExportedFiles(OrderRootType type, List<VirtualFile> result) {
        result.addAll(Arrays.asList(this.getFiles(type)));
    }

    void addExportedUrls(OrderRootType type, List<String> result) {
        result.addAll(Arrays.asList(this.getUrls(type)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray;
        if (OrderRootType.SOURCES.equals((Object)type)) {
            virtualFileArray = this.getRootModel().getSourceRoots();
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl.getFiles must not return null");
            return virtualFileArray;
        }
        virtualFileArray = this.getRootModel().getRootPaths(type);
        if (virtualFileArray != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl.getFiles must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String[] getUrls(OrderRootType type) {
        String[] stringArray;
        ArrayList<String> result = new ArrayList<String>();
        if (!OrderRootType.SOURCES.equals((Object)type)) {
            stringArray = this.getRootModel().getRootUrls(type);
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl.getUrls must not return null");
            return stringArray;
        } else {
            ContentEntry[] content;
            for (ContentEntry contentEntry : content = this.getRootModel().getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    String url = sourceFolder.getUrl();
                    result.add(url);
                }
            }
            stringArray = ArrayUtil.toStringArray(result);
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl.getUrls must not return null");
            return stringArray;
        }
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleSourceOrderEntryImpl(rootModel);
    }

    public boolean isSynthetic() {
        return true;
    }
}

