/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibrarySourceItem
extends PackagingSourceItem {
    private Library myLibrary;

    public LibrarySourceItem(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.<init> must not be null");
        }
        this.myLibrary = library;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.createPresentation must not be null");
        }
        return new LibrarySourceItemPresentation(this.myLibrary, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof LibrarySourceItem && this.myLibrary.equals(((LibrarySourceItem)((Object)obj)).myLibrary);
    }

    public int hashCode() {
        return this.myLibrary.hashCode();
    }

    @NotNull
    public Library getLibrary() {
        Library library = this.myLibrary;
        if (library == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.getLibrary must not return null");
        }
        return library;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        PackagingElementOutputKind packagingElementOutputKind = LibraryPackagingElement.getKindForLibrary(this.myLibrary);
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.getKindOfProducedElements must not return null");
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.createElements must not be null");
        }
        List list = PackagingElementFactory.getInstance().createLibraryElements(this.myLibrary);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem.createElements must not return null");
        }
        return list;
    }

    private static class LibrarySourceItemPresentation
    extends SourceItemPresentation {
        private final Library myLibrary;
        private final ArtifactEditorContext myContext;

        public LibrarySourceItemPresentation(Library library, ArtifactEditorContext context) {
            this.myLibrary = library;
            this.myContext = context;
        }

        public boolean canNavigateToSource() {
            return this.myLibrary != null;
        }

        public void navigateToSource() {
            this.myContext.selectLibrary(this.myLibrary);
        }

        public Object getSourceObject() {
            return this.myLibrary;
        }

        public String getPresentableName() {
            String name = this.myLibrary.getName();
            if (name != null) {
                return name;
            }
            VirtualFile[] files = this.myLibrary.getFiles(OrderRootType.CLASSES);
            return files.length > 0 ? files[0].getName() : "Empty Library";
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem$LibrarySourceItemPresentation.render must not be null");
            }
            String name = this.myLibrary.getName();
            if (name != null) {
                presentationData.setIcons(Icons.LIBRARY_ICON);
                presentationData.addText(name, mainAttributes);
                presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
            } else {
                VirtualFile[] files = this.myLibrary.getFiles(OrderRootType.CLASSES);
                if (files.length > 0) {
                    VirtualFile file = files[0];
                    presentationData.setIcons(file.getIcon());
                    presentationData.addText(file.getName(), mainAttributes);
                } else {
                    presentationData.addText("Empty Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        public int getWeight() {
            return 10;
        }
    }
}

