/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.actions.AddFacetActionGroup;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUtil;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleGroupConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleStructureConfigurable.UI", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class ModuleStructureConfigurable
extends BaseStructureConfigurable
implements Place.Navigator {
    private static final Icon COMPACT_EMPTY_MIDDLE_PACKAGES_ICON = IconLoader.getIcon((String)"/objectBrowser/compactEmptyPackages.png");
    private static final Icon ICON = IconLoader.getIcon((String)"/modules/modules.png");
    private boolean myPlainMode;
    private final ModuleManager myModuleManager;
    private final FacetEditorFacadeImpl myFacetEditorFacade;

    public ModuleStructureConfigurable(Project project, ModuleManager manager) {
        super(project);
        this.myFacetEditorFacade = new FacetEditorFacadeImpl(this, this.TREE_UPDATER);
        this.myModuleManager = manager;
    }

    @Override
    protected void initTree() {
        super.initTree();
        this.myTree.setRootVisible(false);
    }

    protected ArrayList<AnAction> getAdditionalActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(ActionManager.getInstance().getAction("MoveModuleToGroup"));
        return result;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = super.createActions(fromPopup);
        result.add((AnAction)Separator.getInstance());
        result.add((AnAction)new MyGroupAction());
        this.addCollapseExpandActions(result);
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable.createActions must not return null");
        }
        return arrayList;
    }

    @Override
    protected AnAction createCopyAction() {
        return new MyCopyAction();
    }

    @Override
    protected void loadTree() {
        this.createProjectNodes();
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myUiDisposed = false;
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ModuleProjectStructureElement> result = new ArrayList<ModuleProjectStructureElement>();
        for (Module module : this.myModuleManager.getModules()) {
            result.add(new ModuleProjectStructureElement(this.myContext, module));
        }
        ArrayList<ModuleProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable.getProjectStructureElements must not return null");
        }
        return arrayList;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        FacetStructureConfigurable.getInstance(this.myProject).disposeMultipleSettingsEditor();
        ApplicationManager.getApplication().assertIsDispatchThread();
        String selectedTab = ModuleEditor.getSelectedTab();
        this.updateSelection(configurable, selectedTab);
    }

    protected boolean isAutoScrollEnabled() {
        return this.myAutoScrollEnabled;
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return FacetStructureConfigurable.getInstance(this.myProject).updateMultiSelection(selectedConfigurables, this.getDetailsComponent());
    }

    private void updateSelection(NamedConfigurable configurable, String selectedTab) {
        super.updateSelection(configurable);
        if (configurable != null) {
            this.updateTabSelection(configurable, selectedTab);
        }
    }

    private void updateTabSelection(NamedConfigurable configurable, String selectedTab) {
        ModuleConfigurable moduleConfigurable;
        ModuleEditor editor;
        if (configurable instanceof ModuleConfigurable && (editor = (moduleConfigurable = (ModuleConfigurable)configurable).getModuleEditor()) != null) {
            editor.init(selectedTab, this.myHistory);
        }
        if (configurable instanceof FacetConfigurable) {
            ((FacetConfigurable)configurable).getEditor().onFacetSelected();
        }
    }

    private void createProjectNodes() {
        Module[] modules;
        HashMap moduleGroup2NodeMap = new HashMap();
        for (Module module : modules = this.myModuleManager.getModules()) {
            String[] groupPath;
            ModuleConfigurable configurable = new ModuleConfigurable(this.myContext.myModulesConfigurator, module, this.TREE_UPDATER);
            MasterDetailsComponent.MyNode moduleNode = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
            boolean facetsExist = this.myFacetEditorFacade.addFacetsNodes(module, moduleNode);
            if (facetsExist) {
                this.myTree.setShowsRootHandles(true);
            }
            String[] stringArray = groupPath = this.myPlainMode ? null : this.myContext.myModulesConfigurator.getModuleModel().getModuleGroupPath(module);
            if (groupPath == null || groupPath.length == 0) {
                this.addNode(moduleNode, this.myRoot);
                continue;
            }
            MasterDetailsComponent.MyNode moduleGroupNode = ModuleGroupUtil.buildModuleGroupPath(new ModuleGroup(groupPath), this.myRoot, moduleGroup2NodeMap, new Consumer<ModuleGroupUtil.ParentChildRelation<MasterDetailsComponent.MyNode>>(){

                public void consume(ModuleGroupUtil.ParentChildRelation<MasterDetailsComponent.MyNode> parentChildRelation) {
                    ModuleStructureConfigurable.this.addNode(parentChildRelation.getChild(), parentChildRelation.getParent());
                }
            }, new Function<ModuleGroup, MasterDetailsComponent.MyNode>(){

                public MasterDetailsComponent.MyNode fun(ModuleGroup moduleGroup) {
                    ModuleGroupConfigurable moduleGroupConfigurable = new ModuleGroupConfigurable(moduleGroup);
                    return new MasterDetailsComponent.MyNode((NamedConfigurable)moduleGroupConfigurable, true);
                }
            });
            this.addNode(moduleNode, moduleGroupNode);
        }
        if (this.myProject.isDefault()) {
            this.myRoot.removeAllChildren();
        }
    }

    public boolean updateProjectTree(Module[] modules, ModuleGroup group) {
        if (this.myRoot.getChildCount() == 0) {
            return false;
        }
        MasterDetailsComponent.MyNode[] nodes = new MasterDetailsComponent.MyNode[modules.length];
        int i = 0;
        for (Module module : modules) {
            MasterDetailsComponent.MyNode node = this.findModuleNode(module);
            LOG.assertTrue(node != null, (Object)("Module " + module.getName() + " is not in project."));
            node.removeFromParent();
            nodes[i++] = node;
        }
        for (Module module : nodes) {
            String[] groupPath;
            String[] stringArray = this.myPlainMode ? null : (groupPath = group != null ? group.getGroupPath() : null);
            if (groupPath == null || groupPath.length == 0) {
                this.addNode((MasterDetailsComponent.MyNode)module, this.myRoot);
            } else {
                MasterDetailsComponent.MyNode moduleGroupNode = ModuleGroupUtil.updateModuleGroupPath(new ModuleGroup(groupPath), this.myRoot, new Function<ModuleGroup, MasterDetailsComponent.MyNode>(){

                    @Nullable
                    public MasterDetailsComponent.MyNode fun(ModuleGroup group) {
                        return MasterDetailsComponent.findNodeByObject((TreeNode)ModuleStructureConfigurable.this.myRoot, (Object)group);
                    }
                }, new Consumer<ModuleGroupUtil.ParentChildRelation<MasterDetailsComponent.MyNode>>(){

                    public void consume(ModuleGroupUtil.ParentChildRelation<MasterDetailsComponent.MyNode> parentChildRelation) {
                        ModuleStructureConfigurable.this.addNode(parentChildRelation.getChild(), parentChildRelation.getParent());
                    }
                }, new Function<ModuleGroup, MasterDetailsComponent.MyNode>(){

                    public MasterDetailsComponent.MyNode fun(ModuleGroup moduleGroup) {
                        ModuleGroupConfigurable moduleGroupConfigurable = new ModuleGroupConfigurable(moduleGroup);
                        return new MasterDetailsComponent.MyNode((NamedConfigurable)moduleGroupConfigurable, true);
                    }
                });
                this.addNode((MasterDetailsComponent.MyNode)module, moduleGroupNode);
            }
            this.myFacetEditorFacade.addFacetsNodes((Module)module.getConfigurable().getEditableObject(), (MasterDetailsComponent.MyNode)module);
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        return true;
    }

    protected void addNode(MasterDetailsComponent.MyNode nodeToAdd, MasterDetailsComponent.MyNode parent) {
        parent.add((MutableTreeNode)nodeToAdd);
        TreeUtil.sort((DefaultMutableTreeNode)parent, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                MasterDetailsComponent.MyNode node1 = (MasterDetailsComponent.MyNode)o1;
                MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)o2;
                Object editableObject1 = node1.getConfigurable().getEditableObject();
                Object editableObject2 = node2.getConfigurable().getEditableObject();
                if (editableObject1.getClass() == editableObject2.getClass()) {
                    return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
                }
                if (editableObject2 instanceof Module && editableObject1 instanceof ModuleGroup) {
                    return -1;
                }
                if (editableObject1 instanceof Module && editableObject2 instanceof ModuleGroup) {
                    return 1;
                }
                if (editableObject2 instanceof Module && editableObject1 instanceof String) {
                    return 1;
                }
                if (editableObject1 instanceof Module && editableObject2 instanceof String) {
                    return -1;
                }
                if (editableObject2 instanceof ModuleGroup && editableObject1 instanceof String) {
                    return 1;
                }
                if (editableObject1 instanceof ModuleGroup && editableObject2 instanceof String) {
                    return -1;
                }
                return 0;
            }
        });
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)parent);
    }

    @Override
    public void init(StructureConfigurableContext context) {
        super.init(context);
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library) {
                    Library library = (Library)deletedItem;
                    MasterDetailsComponent.MyNode node = MasterDetailsComponent.findNodeByObject((TreeNode)ModuleStructureConfigurable.this.myRoot, (Object)library);
                    if (node != null) {
                        TreeNode parent = node.getParent();
                        node.removeFromParent();
                        ((DefaultTreeModel)ModuleStructureConfigurable.this.myTree.getModel()).reload(parent);
                    }
                    ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new LibraryProjectStructureElement(ModuleStructureConfigurable.this.myContext, library));
                }
            }

            public void itemsExternallyChanged() {
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void apply() throws ConfigurationException {
        HashSet<MasterDetailsComponent.MyNode> roots = new HashSet<MasterDetailsComponent.MyNode>();
        roots.add(this.myRoot);
        this.checkApply(roots, ProjectBundle.message((String)"rename.message.prefix.module", (Object[])new Object[0]), ProjectBundle.message((String)"rename.module.title", (Object[])new Object[0]));
        if (this.myContext.myModulesConfigurator.isModified()) {
            this.myContext.myModulesConfigurator.apply();
        }
    }

    public boolean isModified() {
        return this.myContext.myModulesConfigurator.isModified();
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myFacetEditorFacade.clearMaps(true);
        this.myContext.myModulesConfigurator.disposeUIResources();
        ModuleStructureConfigurable.super.disposeUIResources();
    }

    public void dispose() {
    }

    public JComponent createComponent() {
        return new MyDataProviderWrapper(super.createComponent());
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        if (topic != null) {
            return topic;
        }
        return "reference.settingsdialog.project.structure.module";
    }

    public static ModuleStructureConfigurable getInstance(Project project) {
        return (ModuleStructureConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, ModuleStructureConfigurable.class);
    }

    public void setStartModuleWizard(boolean show) {
        this.myContext.myModulesConfigurator.getModulesConfigurable().setStartModuleWizardOnShow(show);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void selectOrderEntry(final @NotNull Module module, final @Nullable OrderEntry orderEntry) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable.selectOrderEntry must not be null");
        }
        ProjectStructureConfigurable.getInstance(this.myProject).select(module.getName(), null, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                MasterDetailsComponent.MyNode node = ModuleStructureConfigurable.this.findModuleNode(module);
                if (node != null) {
                    ModuleConfigurationEditor editor;
                    ModuleConfigurable moduleConfigurable = (ModuleConfigurable)node.getConfigurable();
                    ModuleEditor moduleEditor = moduleConfigurable.getModuleEditor();
                    moduleEditor.setSelectedTabName(ClasspathEditor.NAME);
                    if (orderEntry != null && (editor = moduleEditor.getEditor(ClasspathEditor.NAME)) instanceof ClasspathEditor) {
                        ((ClasspathEditor)editor).selectOrderEntry(orderEntry);
                    }
                }
            }
        });
    }

    public Module[] getModules() {
        if (this.myContext.myModulesConfigurator != null) {
            ModifiableModuleModel model = this.myContext.myModulesConfigurator.getModuleModel();
            return model.getModules();
        }
        return this.myModuleManager.getModules();
    }

    public void addLibraryOrderEntry(Module module, Library library) {
        OrderEntry[] entries;
        Window parent = WindowManager.getInstance().suggestParentWindow(module.getProject());
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modelProxy = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry entry : entries = modelProxy.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)library.getName()) || Messages.showYesNoDialog((Component)parent, (String)ProjectBundle.message((String)"project.roots.replace.library.entry.message", (Object[])new Object[]{entry.getPresentableName()}), (String)ProjectBundle.message((String)"project.roots.replace.library.entry.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) != 0) continue;
            modelProxy.removeOrderEntry(entry);
            break;
        }
        modelProxy.addLibraryEntry(library);
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        this.myTree.repaint();
    }

    @Nullable
    public MasterDetailsComponent.MyNode findModuleNode(Module module) {
        return ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module);
    }

    public FacetEditorFacadeImpl getFacetEditorFacade() {
        return this.myFacetEditorFacade;
    }

    public ProjectFacetsConfigurator getFacetConfigurator() {
        return this.myContext.myModulesConfigurator.getFacetsConfigurator();
    }

    private void addModule() {
        List<Module> modules = this.myContext.myModulesConfigurator.addModule((Component)this.myTree);
        if (modules != null) {
            for (Module module : modules) {
                this.addModuleNode(module);
            }
        }
    }

    private void addModuleNode(Module module) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new ModuleConfigurable(this.myContext.myModulesConfigurator, module, this.TREE_UPDATER));
        TreePath selectionPath = this.myTree.getSelectionPath();
        MasterDetailsComponent.MyNode parent = null;
        if (selectionPath != null) {
            ModifiableModuleModel modifiableModuleModel;
            String[] groupPath;
            MasterDetailsComponent.MyNode selected = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
            Object o = selected.getConfigurable().getEditableObject();
            if (o instanceof ModuleGroup) {
                this.myContext.myModulesConfigurator.getModuleModel().setModuleGroupPath(module, ((ModuleGroup)o).getGroupPath());
                parent = selected;
            } else if (o instanceof Module && (groupPath = (modifiableModuleModel = this.myContext.myModulesConfigurator.getModuleModel()).getModuleGroupPath((Module)o)) != null) {
                modifiableModuleModel.setModuleGroupPath(module, groupPath);
                parent = ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)new ModuleGroup(groupPath));
            }
        }
        if (parent == null) {
            parent = this.myRoot;
        }
        this.addNode(node, parent);
        this.myFacetEditorFacade.addFacetsNodes(module, node);
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)parent);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
        ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
        daemonAnalyzer.queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        daemonAnalyzer.clearAllProblems();
    }

    @Nullable
    public Module getSelectedModule() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Module) {
            return (Module)selectedObject;
        }
        if (selectedObject instanceof Library && ((Library)selectedObject).getTable() == null) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent();
            return (Module)((MasterDetailsComponent.MyNode)node.getParent()).getConfigurable().getEditableObject();
        }
        return null;
    }

    @NonNls
    public String getId() {
        return "project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public Module getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return this.myContext != null && this.myContext.myModulesConfigurator != null ? this.myContext.myModulesConfigurator.getModule(moduleName) : this.myModuleManager.findModuleByName(moduleName);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        final AddFacetActionGroup addFacetGroup = new AddFacetActionGroup("", true, this.myFacetEditorFacade);
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AddModuleAction module = new AddModuleAction();
                ArrayList<AnAction> result = new ArrayList<AnAction>();
                result.add(module);
                AnAction[] facets = addFacetGroup.getChildren(e);
                if (facets.length > 0) {
                    result.add((AnAction)new Separator(ProjectBundle.message((String)"add.group.facet.separator", (Object[])new Object[0])));
                }
                result.addAll(Arrays.asList(facets));
                AnAction[] anActionArray = result.toArray(new AnAction[result.size()]);
                if (anActionArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$9.getChildren must not return null");
                }
                return anActionArray;
            }
        };
    }

    @Override
    protected List<Facet> removeFacet(Facet facet) {
        List<Facet> removed = super.removeFacet(facet);
        FacetStructureConfigurable.getInstance(this.myProject).removeFacetNodes(removed);
        return removed;
    }

    @Override
    protected boolean removeModule(Module module) {
        ModulesConfigurator modulesConfigurator = this.myContext.myModulesConfigurator;
        if (!modulesConfigurator.deleteModule(module)) {
            return false;
        }
        List<Facet> removed = modulesConfigurator.getFacetsConfigurator().removeAllFacets(module);
        FacetStructureConfigurable.getInstance(this.myProject).removeFacetNodes(removed);
        this.myContext.getDaemonAnalyzer().removeElement(new ModuleProjectStructureElement(this.myContext, module));
        return true;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return ProjectBundle.message((String)"empty.module.selection.string", (Object[])new Object[0]);
    }

    private class AddModuleAction
    extends AnAction
    implements DumbAware {
        public AddModuleAction() {
            super(ProjectBundle.message((String)"add.new.module.text.full", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/modul.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ModuleStructureConfigurable.this.addModule();
        }
    }

    private class MyCopyAction
    extends AnAction
    implements DumbAware {
        private MyCopyAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            NamedConfigurable namedConfigurable = ModuleStructureConfigurable.this.getSelectedConfugurable();
            if (namedConfigurable instanceof ModuleConfigurable) {
                try {
                    final String modulePresentation = IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0]);
                    final NamePathComponent component = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.component.file.location", (Object[])new Object[]{StringUtil.capitalize((String)modulePresentation)}), 'a', 'l', IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{modulePresentation}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)modulePresentation)}));
                    DialogWrapper copyModuleDialog = new DialogWrapper((Component)ModuleStructureConfigurable.this.myTree, false){
                        {
                            super(x0, x1);
                            this.setTitle(ProjectBundle.message((String)"copy.module.dialog.title", (Object[])new Object[0]));
                            this.init();
                        }

                        public JComponent getPreferredFocusedComponent() {
                            return component.getNameComponent();
                        }

                        @Nullable
                        protected JComponent createCenterPanel() {
                            return component;
                        }

                        protected void doOKAction() {
                            if (component.getNameValue().length() == 0) {
                                Messages.showErrorDialog((String)ProjectBundle.message((String)"enter.module.copy.name.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                                return;
                            }
                            if (component.getPath().length() == 0) {
                                Messages.showErrorDialog((String)IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{modulePresentation}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                                return;
                            }
                            if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{modulePresentation}), component.getPath(), true)) {
                                Messages.showErrorDialog((String)ProjectBundle.message((String)"path.0.is.invalid.error.message", (Object[])new Object[]{component.getPath()}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                                return;
                            }
                            super.doOKAction();
                        }
                    };
                    copyModuleDialog.show();
                    if (!copyModuleDialog.isOK()) {
                        return;
                    }
                    final ModifiableRootModel rootModel = ((ModuleConfigurable)namedConfigurable).getModuleEditor().getModifiableRootModel();
                    String path = component.getPath();
                    ModuleBuilder builder = new ModuleBuilder(){

                        public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
                            if (rootModel.isSdkInherited()) {
                                modifiableRootModel.inheritSdk();
                            } else {
                                modifiableRootModel.setSdk(rootModel.getSdk());
                            }
                            ((CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(true);
                            ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevelModuleExtension.getInstance((Module)rootModel.getModule()).getLanguageLevel());
                            for (OrderEntry entry : rootModel.getOrderEntries()) {
                                if (entry instanceof JdkOrderEntry || entry instanceof ModuleSourceOrderEntry || !(entry instanceof ClonableOrderEntry)) continue;
                                modifiableRootModel.addOrderEntry(((ClonableOrderEntry)entry).cloneEntry((RootModelImpl)modifiableRootModel, (ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)ModuleStructureConfigurable.this.myProject), VirtualFilePointerManager.getInstance()));
                            }
                            VirtualFile content = LocalFileSystem.getInstance().findFileByPath(component.getPath());
                            if (content == null) {
                                content = LocalFileSystem.getInstance().refreshAndFindFileByPath(component.getPath());
                            }
                            modifiableRootModel.addContentEntry(content);
                        }

                        public ModuleType getModuleType() {
                            return rootModel.getModule().getModuleType();
                        }
                    };
                    builder.setName(component.getNameValue());
                    builder.setModuleFilePath(path + "/" + builder.getName() + ".iml");
                    Module module = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.addModule(builder);
                    if (module != null) {
                        ModuleStructureConfigurable.this.addModuleNode(module);
                    }
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }

        public void update(AnActionEvent e) {
            TreePath[] selectionPaths = ModuleStructureConfigurable.this.myTree.getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(ModuleStructureConfigurable.this.getSelectedConfugurable() instanceof ModuleConfigurable);
            }
        }
    }

    private class MyGroupAction
    extends ToggleAction
    implements DumbAware {
        public MyGroupAction() {
            super("", "", COMPACT_EMPTY_MIDDLE_PACKAGES_ICON);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            String text = ProjectBundle.message((String)"project.roots.plain.mode.action.text.disabled", (Object[])new Object[0]);
            if (ModuleStructureConfigurable.this.myPlainMode) {
                text = ProjectBundle.message((String)"project.roots.plain.mode.action.text.enabled", (Object[])new Object[0]);
            }
            presentation.setText(text);
            presentation.setDescription(text);
            if (ModuleStructureConfigurable.this.myContext.myModulesConfigurator != null) {
                presentation.setVisible(ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().hasModuleGroups());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return ModuleStructureConfigurable.this.myPlainMode;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Module[] modules;
            ModuleStructureConfigurable.this.myPlainMode = state;
            DefaultMutableTreeNode selection = null;
            TreePath selectionPath = ModuleStructureConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            }
            ModifiableModuleModel model = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel();
            for (Module module : modules = model.getModules()) {
                String[] groupPath = model.getModuleGroupPath(module);
                ModuleStructureConfigurable.this.updateProjectTree(new Module[]{module}, groupPath != null ? new ModuleGroup(groupPath) : null);
            }
            if (state) {
                this.removeModuleGroups();
            }
            if (selection != null) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)selection, (boolean)true, (JTree)ModuleStructureConfigurable.this.myTree);
            }
        }

        private void removeModuleGroups() {
            for (int i = ModuleStructureConfigurable.this.myRoot.getChildCount() - 1; i >= 0; --i) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)ModuleStructureConfigurable.this.myRoot.getChildAt(i);
                if (!(node.getConfigurable().getEditableObject() instanceof ModuleGroup)) continue;
                node.removeFromParent();
            }
            ((DefaultTreeModel)ModuleStructureConfigurable.this.myTree.getModel()).reload((TreeNode)ModuleStructureConfigurable.this.myRoot);
        }
    }

    private class MyDataProviderWrapper
    extends JPanel
    implements DataProvider {
        public MyDataProviderWrapper(JComponent component) {
            super(new BorderLayout());
            this.add((Component)component, "Center");
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            TreePath[] paths;
            if (DataKeys.MODULE_CONTEXT_ARRAY.is(dataId) && (paths = ModuleStructureConfigurable.this.myTree.getSelectionPaths()) != null) {
                ArrayList<Module> modules = new ArrayList<Module>();
                for (TreePath path : paths) {
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)path.getLastPathComponent();
                    NamedConfigurable configurable = node.getConfigurable();
                    LOG.assertTrue(configurable != null, (Object)"already disposed");
                    Object o = configurable.getEditableObject();
                    if (!(o instanceof Module)) continue;
                    modules.add((Module)o);
                }
                return !modules.isEmpty() ? modules.toArray(new Module[modules.size()]) : null;
            }
            if (DataKeys.MODULE_CONTEXT.is(dataId)) {
                return ModuleStructureConfigurable.this.getSelectedModule();
            }
            if (LangDataKeys.MODIFIABLE_MODULE_MODEL.is(dataId)) {
                return ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel();
            }
            return null;
        }
    }
}

