/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileHolderComposite
implements FileHolder {
    private final Map<FileHolder.HolderType, FileHolder> myHolders = new HashMap<FileHolder.HolderType, FileHolder>();

    public FileHolderComposite(Project project) {
        this.myHolders.put(FileHolder.HolderType.UNVERSIONED, new VirtualFileHolder(project, FileHolder.HolderType.UNVERSIONED));
        this.myHolders.put(FileHolder.HolderType.ROOT_SWITCH, new SwitchedFileHolder(project, FileHolder.HolderType.ROOT_SWITCH));
        this.myHolders.put(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING, new VirtualFileHolder(project, FileHolder.HolderType.MODIFIED_WITHOUT_EDITING));
        this.myHolders.put(FileHolder.HolderType.IGNORED, new RecursiveFileHolder(project, FileHolder.HolderType.IGNORED));
        this.myHolders.put(FileHolder.HolderType.LOCKED, new VirtualFileHolder(project, FileHolder.HolderType.LOCKED));
        this.myHolders.put(FileHolder.HolderType.LOGICALLY_LOCKED, new LogicallyLockedHolder(project));
    }

    public FileHolderComposite(FileHolderComposite holder) {
        for (FileHolder fileHolder : holder.myHolders.values()) {
            this.myHolders.put(fileHolder.getType(), fileHolder.copy());
        }
    }

    public FileHolder add(@NotNull FileHolder fileHolder, boolean copy) {
        if (fileHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/FileHolderComposite.add must not be null");
        }
        FileHolder added = copy ? fileHolder.copy() : fileHolder;
        this.myHolders.put(fileHolder.getType(), added);
        return added;
    }

    @Override
    public void cleanAll() {
        for (FileHolder holder : this.myHolders.values()) {
            holder.cleanAll();
        }
    }

    @Override
    public void cleanScope(VcsDirtyScope scope) {
        for (FileHolder holder : this.myHolders.values()) {
            holder.cleanScope(scope);
        }
    }

    @Override
    public FileHolder copy() {
        return new FileHolderComposite(this);
    }

    public FileHolder get(FileHolder.HolderType type) {
        return this.myHolders.get((Object)type);
    }

    public VirtualFileHolder getVFHolder(FileHolder.HolderType type) {
        return (VirtualFileHolder)this.myHolders.get((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHolderComposite another = (FileHolderComposite)o;
        if (another.myHolders.size() != this.myHolders.size()) {
            return false;
        }
        for (Map.Entry<FileHolder.HolderType, FileHolder> entry : this.myHolders.entrySet()) {
            if (entry.getValue().equals(another.myHolders.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myHolders != null ? ((Object)this.myHolders).hashCode() : 0;
    }

    @Override
    public FileHolder.HolderType getType() {
        throw new UnsupportedOperationException();
    }

    public RecursiveFileHolder getIgnoredFileHolder() {
        return (RecursiveFileHolder)this.myHolders.get((Object)FileHolder.HolderType.IGNORED);
    }
}

