/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ContentRevision {
    private final DiffProvider myDiffProvider;
    private final VirtualFile myFile;
    private ContentRevision myVcsRevision;

    public VcsCurrentRevisionProxy(DiffProvider diffProvider, VirtualFile file) {
        this.myDiffProvider = diffProvider;
        this.myFile = file;
    }

    @Nullable
    public String getContent() throws VcsException {
        return this.getVcsRevision().getContent();
    }

    @NotNull
    public FilePath getFile() {
        FilePathImpl filePathImpl = new FilePathImpl(this.myFile);
        if (filePathImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy.getFile must not return null");
        }
        return filePathImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber;
        VcsRevisionNumber vcsRevisionNumber2;
        try {
            vcsRevisionNumber2 = this.getVcsRevision().getRevisionNumber();
        }
        catch (VcsException ex) {
            vcsRevisionNumber = VcsRevisionNumber.NULL;
            if (vcsRevisionNumber == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy.getRevisionNumber must not return null");
            return vcsRevisionNumber;
        }
        vcsRevisionNumber = vcsRevisionNumber2;
        if (vcsRevisionNumber2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy.getRevisionNumber must not return null");
        return vcsRevisionNumber;
    }

    private ContentRevision getVcsRevision() throws VcsException {
        if (this.myVcsRevision == null) {
            VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
            if (currentRevision == null) {
                throw new VcsException("Failed to fetch current revision");
            }
            this.myVcsRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
            if (this.myVcsRevision == null) {
                throw new VcsException("Failed to create content for current revision");
            }
        }
        return this.myVcsRevision;
    }
}

