/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import java.util.Arrays;
import java.util.List;

public class CommitAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        boolean enabled = false;
        if (project != null) {
            if (ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
            if (changes != null && ChangesUtil.allChangesInOneList((Project)project, (Change[])changes)) {
                for (Change c : changes) {
                    AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)c, (Project)project);
                    if (vcs == null || vcs.getCheckinEnvironment() == null) continue;
                    enabled = true;
                    break;
                }
            }
        }
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            return;
        }
        final Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        final ChangeList list = ChangesUtil.getChangeListIfOnlyOne((Project)project, (Change[])changes);
        if (list == null || !(list instanceof LocalChangeList)) {
            return;
        }
        ChangeListManager.getInstance((Project)project).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                List<Change> changesList = Arrays.asList(changes);
                List<CommitExecutor> executors = CommitChangeListDialog.collectExecutors(project, changesList);
                CommitChangeListDialog.commitChanges(project, changesList, (LocalChangeList)list, executors, true, null);
            }
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), null);
    }
}

