/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RootsCalculator;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ConcurrentHashMap;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CachesHolder {
    @NonNls
    private static final String VCS_CACHE_PATH = "vcsCache";
    private final Project myProject;
    private final Map<String, ChangesCacheFile> myCacheFiles;
    private final RepositoryLocationCache myLocationCache;
    private final ProjectLevelVcsManager myPlManager;

    public CachesHolder(Project project, RepositoryLocationCache locationCache) {
        this.myProject = project;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myCacheFiles = new ConcurrentHashMap();
    }

    public Map<VirtualFile, RepositoryLocation> getAllRootsUnderVcs(AbstractVcs vcs) {
        RootsCalculator calculator = new RootsCalculator(this.myProject, vcs, this.myLocationCache);
        return calculator.getRoots();
    }

    public void iterateAllCaches(NotNullFunction<ChangesCacheFile, Boolean> consumer) {
        AbstractVcs[] vcses;
        for (AbstractVcs vcs : vcses = this.myPlManager.getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider)) continue;
            Map<VirtualFile, RepositoryLocation> map = this.getAllRootsUnderVcs(vcs);
            for (VirtualFile root : map.keySet()) {
                RepositoryLocation location;
                ChangesCacheFile cacheFile = this.getCacheFile(vcs, root, location = map.get(root));
                if (!Boolean.TRUE.equals(consumer.fun((Object)cacheFile))) continue;
                return;
            }
        }
    }

    public List<ChangesCacheFile> getAllCaches() {
        final ArrayList<ChangesCacheFile> result = new ArrayList<ChangesCacheFile>();
        this.iterateAllCaches(new NotNullFunction<ChangesCacheFile, Boolean>(){

            @NotNull
            public Boolean fun(ChangesCacheFile changesCacheFile) {
                result.add(changesCacheFile);
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/CachesHolder$1.fun must not return null");
                }
                return bl;
            }
        });
        return result;
    }

    public ChangesCacheFile getCacheFile(AbstractVcs vcs, VirtualFile root, RepositoryLocation location) {
        String key = location.getKey();
        ChangesCacheFile cacheFile = this.myCacheFiles.get(key);
        if (cacheFile == null) {
            cacheFile = new ChangesCacheFile(this.myProject, this.getCachePath(location), vcs, root, location);
            this.myCacheFiles.put(key, cacheFile);
        }
        return cacheFile;
    }

    public File getCacheBasePath() {
        File file = new File(PathManager.getSystemPath(), VCS_CACHE_PATH);
        file = new File(file, this.myProject.getLocationHash());
        return file;
    }

    private File getCachePath(RepositoryLocation location) {
        File file = this.getCacheBasePath();
        file.mkdirs();
        String s = location.getKey();
        try {
            byte[] bytes = MessageDigest.getInstance("MD5").digest(CharsetToolkit.getUtf8Bytes((String)s));
            StringBuilder result = new StringBuilder();
            for (byte aByte : bytes) {
                result.append(String.format("%02x", aByte));
            }
            return new File(file, result.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

