/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.BinaryContent;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.TextTransferrable;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.util.Alarm;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Icons;
import com.intellij.util.TreeItem;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.TableViewModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanelImpl<S extends CommittedChangeList, U extends ChangeBrowserSettings>
extends PanelWithActionsAndCloseButton {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.ui.FileHistoryDialog");
    private final JEditorPane myComments;
    private JComponent myAdditionalDetails;
    private Consumer<VcsFileRevision> myListener;
    private String myOriginalComment = "";
    private final DefaultActionGroup myPopupActions;
    private final Project myProject;
    private final VcsHistoryProvider myProvider;
    private final AnnotationProvider myAnnotationProvider;
    private VcsHistorySession myHistorySession;
    private final FilePath myFilePath;
    private final Runnable myRefresher;
    private final DualView myDualView;
    private final Map<VcsRevisionNumber, Integer> myRevisionsOrder;
    private final Alarm myUpdateAlarm;
    private volatile boolean myInRefresh;
    private List<Object> myTargetSelection;
    private final AsynchConsumer<VcsHistorySession> myHistoryPanelRefresh;
    private static final String COMMIT_MESSAGE_TITLE = VcsBundle.message((String)"label.selected.revision.commit.message", (Object[])new Object[0]);
    @NonNls
    private static final String VCS_HISTORY_ACTIONS_GROUP = "VcsHistoryActionsGroup";
    private final Comparator<VcsFileRevision> myRevisionsInOrderComparator = new Comparator<VcsFileRevision>(){

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return Comparing.compare((Comparable)((Comparable)FileHistoryPanelImpl.this.myRevisionsOrder.get(o2.getRevisionNumber())), (Comparable)((Comparable)FileHistoryPanelImpl.this.myRevisionsOrder.get(o1.getRevisionNumber())));
        }
    };
    private final DualViewColumnInfo REVISION = new VcsColumnInfo<VcsRevisionNumber>(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0])){

        @Override
        protected VcsRevisionNumber getDataOf(VcsFileRevision object) {
            return object.getRevisionNumber();
        }

        @Override
        public String valueOf(VcsFileRevision object) {
            return object.getRevisionNumber().asString();
        }

        public void sort(@NotNull List<VcsFileRevision> vcsFileRevisions) {
            if (vcsFileRevisions == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/history/FileHistoryPanelImpl$2.sort must not be null");
            }
            Collections.sort(vcsFileRevisions, FileHistoryPanelImpl.this.myRevisionsInOrderComparator);
        }

        public String getPreferredStringValue() {
            return "123.4567";
        }
    };
    private static final DualViewColumnInfo DATE = new VcsColumnInfo<String>(VcsBundle.message((String)"column.name.revision.date", (Object[])new Object[0])){

        @Override
        protected String getDataOf(VcsFileRevision object) {
            Date date = object.getRevisionDate();
            if (date == null) {
                return "";
            }
            return DATE_FORMAT.format(date);
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return o1.getRevisionDate().compareTo(o2.getRevisionDate());
        }

        public String getPreferredStringValue() {
            return DATE_FORMAT.format(new Date());
        }
    };
    private static final DualViewColumnInfo AUTHOR = new VcsColumnInfo<String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        @Override
        protected String getDataOf(VcsFileRevision object) {
            return object.getAuthor();
        }

        @NonNls
        public String getPreferredStringValue() {
            return "author_author";
        }
    };
    private JLabel myLoadingLabel;
    private Splitter mySplitter;
    private final DualViewColumnInfo[] COLUMNS;
    private static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(3, 3);
    private final Map<VcsFileRevision, VirtualFile> myRevisionToVirtualFile = new HashMap<VcsFileRevision, VirtualFile>();

    public FileHistoryPanelImpl(Project project, FilePath filePath, String repositoryPath, VcsHistorySession session, VcsHistoryProvider provider, AnnotationProvider annotationProvider, ContentManager contentManager, Runnable refresher) {
        super(contentManager, provider.getHelpId() != null ? provider.getHelpId() : "reference.versionControl.toolwindow.history");
        this.myProvider = provider;
        this.myAnnotationProvider = annotationProvider;
        this.myProject = project;
        this.myRefresher = refresher;
        this.myHistorySession = session;
        this.myFilePath = filePath;
        this.COLUMNS = this.createColumnList(project, provider, session);
        this.myComments = new JEditorPane("text/html", "");
        this.myComments.setPreferredSize(new Dimension(150, 100));
        this.myComments.setEditable(false);
        this.myComments.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myComments.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.myRevisionsOrder = new HashMap<VcsRevisionNumber, Integer>();
        this.refreshRevisionsOrder();
        this.replaceTransferable();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        HistoryAsTreeProvider treeHistoryProvider = this.myHistorySession.getHistoryAsTreeProvider();
        String storageKey = "FileHistory." + provider.getClass().getName();
        if (treeHistoryProvider != null) {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(new ArrayList(this.myHistorySession.getRevisionList()))), this.COLUMNS, storageKey, project);
        } else {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, FileHistoryPanelImpl.wrapWithTreeElements(new ArrayList<VcsFileRevision>(this.myHistorySession.getRevisionList()))), this.COLUMNS, storageKey, project);
            this.myDualView.switchToTheFlatMode();
        }
        TableLinkMouseListener listener = new TableLinkMouseListener();
        listener.install((Component)this.myDualView.getFlatView());
        listener.install((Component)this.myDualView.getTreeView());
        this.createDualView();
        this.myPopupActions = this.createPopupActions();
        this.myHistoryPanelRefresh = new AsynchConsumer<VcsHistorySession>(){

            public void finished() {
                FileHistoryPanelImpl.this.myInRefresh = false;
                FileHistoryPanelImpl.this.myTargetSelection = null;
                FileHistoryPanelImpl.this.myLoadingLabel.setVisible(false);
                FileHistoryPanelImpl.this.mySplitter.revalidate();
                FileHistoryPanelImpl.this.mySplitter.repaint();
            }

            public void consume(VcsHistorySession vcsHistorySession) {
                FileHistoryPanelImpl.this.refresh(vcsHistorySession);
            }
        };
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (FileHistoryPanelImpl.this.myProject.isDisposed()) {
                    return;
                }
                boolean refresh = !FileHistoryPanelImpl.this.myInRefresh && FileHistoryPanelImpl.this.myHistorySession.shouldBeRefreshed();
                FileHistoryPanelImpl.this.myUpdateAlarm.cancelAllRequests();
                FileHistoryPanelImpl.this.myUpdateAlarm.addRequest((Runnable)this, 20000);
                if (refresh) {
                    FileHistoryPanelImpl.this.refreshImpl();
                }
            }
        }, 20000);
        this.init();
        this.chooseView();
    }

    private void replaceTransferable() {
        final TransferHandler originalTransferHandler = this.myComments.getTransferHandler();
        TransferHandler newHandler = new TransferHandler("copy"){

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                originalTransferHandler.exportAsDrag(comp, e, action);
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                TextTransferrable t;
                if ((action == 1 || action == 2) && (this.getSourceActions(comp) & action) != 0 && (t = new TextTransferrable(FileHistoryPanelImpl.this.myComments.getText(), FileHistoryPanelImpl.this.myOriginalComment)) != null) {
                    try {
                        clip.setContents(t, null);
                        this.exportDone(comp, t, action);
                        return;
                    }
                    catch (IllegalStateException ise) {
                        this.exportDone(comp, t, 0);
                        throw ise;
                    }
                }
                this.exportDone(comp, null, 0);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return originalTransferHandler.importData(comp, t);
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return originalTransferHandler.canImport(comp, transferFlavors);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return originalTransferHandler.getSourceActions(c);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                return originalTransferHandler.getVisualRepresentation(t);
            }
        };
        this.myComments.setTransferHandler(newHandler);
    }

    private DualViewColumnInfo[] createColumnList(Project project, VcsHistoryProvider provider, VcsHistorySession session) {
        VcsDependentHistoryComponents components = provider.getUICustomization(session, (JComponent)((Object)this));
        this.myAdditionalDetails = components.getDetailsComponent();
        this.myListener = components.getRevisionListener();
        ArrayList<DualViewColumnInfo> columns = new ArrayList<DualViewColumnInfo>();
        if (provider.isDateOmittable()) {
            columns.addAll(Arrays.asList(this.REVISION, AUTHOR));
        } else {
            columns.addAll(Arrays.asList(this.REVISION, DATE, AUTHOR));
        }
        columns.addAll(FileHistoryPanelImpl.wrapAdditionalColumns(components.getColumns()));
        columns.add(new MessageColumnInfo(project));
        return columns.toArray(new DualViewColumnInfo[columns.size()]);
    }

    private static Collection<DualViewColumnInfo> wrapAdditionalColumns(ColumnInfo[] additionalColumns) {
        ArrayList<DualViewColumnInfo> result = new ArrayList<DualViewColumnInfo>();
        if (additionalColumns != null) {
            for (ColumnInfo additionalColumn : additionalColumns) {
                result.add(new MyColumnWrapper(additionalColumn));
            }
        }
        return result;
    }

    private static List<TreeItem<VcsFileRevision>> wrapWithTreeElements(List<VcsFileRevision> revisions) {
        ArrayList<TreeItem<VcsFileRevision>> result = new ArrayList<TreeItem<VcsFileRevision>>();
        for (VcsFileRevision revision : revisions) {
            result.add((TreeItem<VcsFileRevision>)new TreeItem((Object)revision));
        }
        return result;
    }

    private void refresh(VcsHistorySession session) {
        this.myHistorySession = session;
        this.refreshRevisionsOrder();
        HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
        if (treeHistoryProvider != null) {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(new ArrayList(this.myHistorySession.getRevisionList()))), this.myTargetSelection);
        } else {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, FileHistoryPanelImpl.wrapWithTreeElements(new ArrayList<VcsFileRevision>(this.myHistorySession.getRevisionList()))), this.myTargetSelection);
        }
        this.myDualView.expandAll();
        this.myDualView.repaint();
    }

    protected void addActionsTo(DefaultActionGroup group) {
        this.addToGroup(false, group);
    }

    private void createDualView() {
        this.myDualView.setShowGrid(true);
        this.myDualView.getTreeView().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)FileHistoryPanelImpl.this.myPopupActions);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myDualView.getFlatView().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)FileHistoryPanelImpl.this.myPopupActions);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myDualView.requestFocus();
        this.myDualView.setSelectionInterval(0, 0);
        this.myDualView.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileHistoryPanelImpl.this.updateMessage();
            }
        });
        this.myDualView.setRootVisible(false);
        this.myDualView.expandAll();
        TreeCellRenderer defaultCellRenderer = this.myDualView.getTree().getCellRenderer();
        Getter<VcsHistorySession> sessionGetter = new Getter<VcsHistorySession>(){

            public VcsHistorySession get() {
                return FileHistoryPanelImpl.this.myHistorySession;
            }
        };
        this.myDualView.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(defaultCellRenderer, sessionGetter));
        this.myDualView.setCellWrapper((CellWrapper)new MyCellWrapper(sessionGetter));
        TableViewModel sortableModel = this.myDualView.getFlatView().getTableViewModel();
        sortableModel.setSortable(true);
        if (null == null) {
            sortableModel.sortByColumn(0, 2);
        } else {
            sortableModel.sortByColumn(this.getColumnIndex(null), 2);
        }
    }

    private int getColumnIndex(ColumnInfo defaultColumnToSortBy) {
        for (int i = 0; i < this.COLUMNS.length; ++i) {
            DualViewColumnInfo dualViewColumnInfo = this.COLUMNS[i];
            if (!(dualViewColumnInfo instanceof MyColumnWrapper) || ((MyColumnWrapper)dualViewColumnInfo).getOriginalColumn() != defaultColumnToSortBy) continue;
            return i;
        }
        return 0;
    }

    private static void makeBold(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Font font = jComponent.getFont();
            if (font != null) {
                jComponent.setFont(font.deriveFont(1));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FileHistoryPanelImpl.makeBold(container.getComponent(i));
            }
        }
    }

    private void updateMessage() {
        VcsFileRevision revision;
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.size() != 1) {
            revision = null;
            this.myComments.setText("");
            this.myOriginalComment = "";
        } else {
            String message;
            revision = this.getFirstSelectedRevision();
            this.myOriginalComment = message = revision.getCommitMessage();
            String text = IssueLinkHtmlRenderer.formatTextIntoHtml(this.myProject, message);
            this.myComments.setText(text);
            this.myComments.setCaretPosition(0);
        }
        if (this.myListener != null) {
            this.myListener.consume((Object)revision);
        }
    }

    private void showDifferences(Project project, VcsFileRevision revision1, VcsFileRevision revision2) {
        try {
            byte[] content1;
            revision1.loadContent();
            revision2.loadContent();
            VcsFileRevision left = revision1;
            VcsFileRevision right = revision2;
            if (VcsHistoryUtil.compare((VcsFileRevision)revision1, (VcsFileRevision)revision2) > 0) {
                left = revision2;
                right = revision1;
            }
            if ((content1 = left.getContent()) == null) {
                throw new VcsException("Failed to load content for revision " + left.getRevisionNumber().asString());
            }
            byte[] content2 = right.getContent();
            if (content2 == null) {
                throw new VcsException("Failed to load content for revision " + right.getRevisionNumber().asString());
            }
            SimpleDiffRequest diffData = new SimpleDiffRequest(this.myProject, this.myFilePath.getPresentableUrl());
            diffData.addHint(DiffTool.HINT_SHOW_FRAME);
            Document doc = this.myFilePath.getDocument();
            Charset charset = this.myFilePath.getCharset();
            FileType fileType = this.myFilePath.getFileType();
            diffData.setContentTitles(left.getRevisionNumber().asString(), right.getRevisionNumber().asString());
            diffData.setContents(FileHistoryPanelImpl.createContent(project, content1, left, doc, charset, fileType), FileHistoryPanelImpl.createContent(project, content2, right, doc, charset, fileType));
            DiffManager.getInstance().getDiffTool().show((DiffRequest)diffData);
        }
        catch (VcsException e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.show.differences", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.show.differences", (Object[])new Object[0]));
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (ProcessCanceledException ex) {
            return;
        }
    }

    private static DiffContent createContent(Project project, byte[] content1, VcsFileRevision revision, Document doc, Charset charset, FileType fileType) {
        if (FileHistoryPanelImpl.isCurrent(revision) && doc != null) {
            return new DocumentContent(project, doc);
        }
        return new BinaryContent(content1, charset, fileType);
    }

    private static boolean isCurrent(VcsFileRevision revision) {
        return revision instanceof CurrentRevision;
    }

    protected JComponent createCenterPanel() {
        this.mySplitter = new Splitter(true, this.getSplitterProportion());
        this.mySplitter.setDividerWidth(4);
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    FileHistoryPanelImpl.this.setSplitterProportionTo((Float)evt.getNewValue());
                }
            }
        });
        Splitter detailsSplitter = new Splitter(false, 0.5f);
        JPanel commentGroup = new JPanel(new BorderLayout(4, 4));
        JLabel commentLabel = new JLabel(COMMIT_MESSAGE_TITLE + ":"){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getWidth(), 21);
            }
        };
        commentGroup.add((Component)commentLabel, "North");
        JScrollPane pane = ScrollPaneFactory.createScrollPane((JComponent)this.myComments);
        pane.setBorder(BorderFactory.createMatteBorder(1, 1, this.myAdditionalDetails == null ? 0 : 1, 0, UIUtil.getBorderSeparatorColor()));
        commentGroup.add((Component)pane, "Center");
        detailsSplitter.setFirstComponent((JComponent)commentGroup);
        detailsSplitter.setSecondComponent(this.myAdditionalDetails);
        JPanel wrapper = new JPanel(new BorderLayout());
        this.myLoadingLabel = new JLabel("Loading...");
        this.myLoadingLabel.setBackground(UIUtil.getToolTipBackground());
        wrapper.add((Component)this.myLoadingLabel, "North");
        this.myDualView.setViewBorder((Border)BorderFactory.createMatteBorder(0, 1, 1, 0, UIUtil.getBorderSeparatorColor()));
        wrapper.add((Component)this.myDualView, "Center");
        this.mySplitter.setFirstComponent((JComponent)wrapper);
        this.mySplitter.setSecondComponent((JComponent)detailsSplitter);
        return this.mySplitter;
    }

    private void chooseView() {
        if (this.showTree()) {
            this.myDualView.switchToTheTreeMode();
        } else {
            this.myDualView.switchToTheFlatMode();
        }
    }

    private boolean showTree() {
        return this.getConfiguration().SHOW_FILE_HISTORY_AS_TREE;
    }

    private void setSplitterProportionTo(Float newProportion) {
        this.getConfiguration().FILE_HISTORY_SPLITTER_PROPORTION = newProportion.floatValue();
    }

    private float getSplitterProportion() {
        return this.getConfiguration().FILE_HISTORY_SPLITTER_PROPORTION;
    }

    private VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    private DefaultActionGroup createPopupActions() {
        return this.addToGroup(true, new DefaultActionGroup(null, false));
    }

    private DefaultActionGroup addToGroup(boolean popup, DefaultActionGroup result) {
        if (popup) {
            result.add(ActionManager.getInstance().getAction("EditSource"));
        }
        MyDiffAction diffAction = new MyDiffAction();
        result.add((AnAction)diffAction);
        if (!popup) {
            diffAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{CommonShortcuts.getDiff().getShortcuts()[0], CommonShortcuts.DOUBLE_CLICK_1.getShortcuts()[0]}), (JComponent)this.myDualView.getFlatView());
            diffAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{CommonShortcuts.getDiff().getShortcuts()[0], CommonShortcuts.DOUBLE_CLICK_1.getShortcuts()[0]}), (JComponent)this.myDualView.getTreeView());
        } else {
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)((Object)this));
        }
        AnAction diffGroup = ActionManager.getInstance().getAction(VCS_HISTORY_ACTIONS_GROUP);
        if (diffGroup != null) {
            result.add(diffGroup);
        }
        result.add((AnAction)new CreatePatchFromChangesAction(){

            @Override
            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(true);
                int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
                e.getPresentation().setEnabled(selectionSize > 0 && selectionSize < 3);
            }
        });
        result.add((AnAction)new MyGetVersionAction());
        result.add((AnAction)new MyAnnotateAction());
        AnAction[] additionalActions = this.myProvider.getAdditionalActions(new Runnable(){

            @Override
            public void run() {
                FileHistoryPanelImpl.this.refreshImpl();
            }
        });
        if (additionalActions != null) {
            for (AnAction additionalAction : additionalActions) {
                result.add(additionalAction);
            }
        }
        result.add((AnAction)new RefreshFileHistoryAction());
        if (!popup && this.supportsTree()) {
            result.add((AnAction)new MyShowAsTreeAction());
        }
        return result;
    }

    private void refreshImpl() {
        new AbstractCalledLater(this.myProject, ModalityState.NON_MODAL){

            @Override
            public void run() {
                if (FileHistoryPanelImpl.this.myInRefresh) {
                    return;
                }
                FileHistoryPanelImpl.this.myInRefresh = true;
                FileHistoryPanelImpl.this.myTargetSelection = FileHistoryPanelImpl.this.myDualView.getFlatView().getSelectedObjects();
                FileHistoryPanelImpl.this.myLoadingLabel.setVisible(true);
                FileHistoryPanelImpl.this.mySplitter.revalidate();
                FileHistoryPanelImpl.this.mySplitter.repaint();
                FileHistoryPanelImpl.this.myRefresher.run();
            }
        }.callMe();
    }

    public AsynchConsumer<VcsHistorySession> getHistoryPanelRefresh() {
        return this.myHistoryPanelRefresh;
    }

    private boolean supportsTree() {
        return this.myHistorySession != null && this.myHistorySession.getHistoryAsTreeProvider() != null;
    }

    public Object getData(String dataId) {
        VcsFileRevision firstSelectedRevision = this.getFirstSelectedRevision();
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            List<TreeNodeOnVcsRevision> selectedItems = this.getSelection();
            if (selectedItems.size() != 1) {
                return null;
            }
            if (!this.myHistorySession.isContentAvailable(firstSelectedRevision)) {
                return null;
            }
            VirtualFile virtualFileForRevision = this.createVirtualFileForRevision(firstSelectedRevision);
            if (virtualFileForRevision != null) {
                return new OpenFileDescriptor(this.myProject, virtualFileForRevision);
            }
            return null;
        }
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return firstSelectedRevision;
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return this.getSelectedRevisions();
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getChanges();
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            if (firstSelectedRevision == null) {
                return null;
            }
            return this.createVirtualFileForRevision(firstSelectedRevision);
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.IO_FILE.is(dataId)) {
            return this.myFilePath.getIOFile();
        }
        if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            if (this.getVirtualFile() == null) {
                return null;
            }
            if (this.getVirtualFile().isValid()) {
                return this.getVirtualFile();
            }
            return null;
        }
        if (VcsDataKeys.FILE_HISTORY_PANEL.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Nullable
    private Change[] getChanges() {
        VcsFileRevision[] revisions = this.getSelectedRevisions();
        if (revisions.length > 0) {
            Arrays.sort(revisions, new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                    return o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
                }
            });
            for (VcsFileRevision revision : revisions) {
                if (this.myHistorySession.isContentAvailable(revision)) continue;
                return null;
            }
            LoadedContentRevision startRevision = new LoadedContentRevision(this.myFilePath, revisions[0]);
            Object endRevision = revisions.length == 1 ? new CurrentContentRevision(this.myFilePath) : new LoadedContentRevision(this.myFilePath, revisions[revisions.length - 1]);
            return new Change[]{new Change((ContentRevision)startRevision, (ContentRevision)endRevision)};
        }
        return null;
    }

    private VirtualFile createVirtualFileForRevision(VcsFileRevision revision) {
        if (!this.myRevisionToVirtualFile.containsKey(revision)) {
            this.myRevisionToVirtualFile.put(revision, (VirtualFile)new VcsVirtualFile(this.myFilePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance()));
        }
        return this.myRevisionToVirtualFile.get(revision);
    }

    private List<TreeNodeOnVcsRevision> getSelection() {
        return this.myDualView.getSelection();
    }

    @Nullable
    private VcsFileRevision getFirstSelectedRevision() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0).myRevision;
    }

    public VcsFileRevision[] getSelectedRevisions() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        VcsFileRevision[] result = new VcsFileRevision[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            result[i] = selection.get(i).myRevision;
        }
        return result;
    }

    @Nullable
    private VcsFileRevision getSelectedRevision(int index) {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(index).myRevision;
    }

    protected void dispose() {
        super.dispose();
        this.myDualView.dispose();
        this.myUpdateAlarm.dispose();
    }

    private VirtualFile getVirtualFile() {
        return this.myFilePath.getVirtualFile();
    }

    private VirtualFile getVirtualParent() {
        return this.myFilePath.getVirtualFileParent();
    }

    private void refreshRevisionsOrder() {
        List list = this.myHistorySession.getRevisionList();
        this.myRevisionsOrder.clear();
        int cnt = 0;
        for (VcsFileRevision revision : list) {
            this.myRevisionsOrder.put(revision.getRevisionNumber(), cnt);
            ++cnt;
        }
    }

    private class RefreshFileHistoryAction
    extends AnAction
    implements DumbAware {
        public RefreshFileHistoryAction() {
            super(VcsBundle.message((String)"action.name.refresh", (Object[])new Object[0]), VcsBundle.message((String)"action.desctiption.refresh", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/sync.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.myInRefresh) {
                return;
            }
            FileHistoryPanelImpl.this.refreshImpl();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!FileHistoryPanelImpl.this.myInRefresh);
        }
    }

    private static class MyCellWrapper
    implements CellWrapper {
        private final Getter<VcsHistorySession> myHistorySession;

        public MyCellWrapper(Getter<VcsHistorySession> historySession) {
            this.myHistorySession = historySession;
        }

        public void wrap(Component component, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, Object treeNode) {
            VcsFileRevision revision = (VcsFileRevision)treeNode;
            if (revision == null) {
                return;
            }
            if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                FileHistoryPanelImpl.makeBold(component);
            }
        }
    }

    private class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myDefaultCellRenderer;
        private final Getter<VcsHistorySession> myHistorySession;

        public MyTreeCellRenderer(TreeCellRenderer defaultCellRenderer, Getter<VcsHistorySession> historySession) {
            this.myDefaultCellRenderer = defaultCellRenderer;
            this.myHistorySession = historySession;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            VcsFileRevision revision;
            Component result = this.myDefaultCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path == null) {
                return result;
            }
            VcsFileRevision vcsFileRevision = revision = row >= 0 ? (VcsFileRevision)path.getLastPathComponent() : null;
            if (revision != null) {
                if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    FileHistoryPanelImpl.makeBold(result);
                }
                if (!selected && ((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    result.setBackground(new Color(188, 227, 231));
                    ((JComponent)result).setOpaque(false);
                }
            } else if (selected) {
                result.setBackground(UIUtil.getTableSelectionBackground());
            } else {
                result.setBackground(UIUtil.getTableBackground());
            }
            return result;
        }
    }

    private static class MyColumnWrapper<T>
    extends DualViewColumnInfo<TreeNodeOnVcsRevision, Object> {
        private final ColumnInfo<VcsFileRevision, T> myBaseColumn;

        public Comparator<TreeNodeOnVcsRevision> getComparator() {
            final Comparator comparator = this.myBaseColumn.getComparator();
            if (comparator == null) {
                return null;
            }
            return new Comparator<TreeNodeOnVcsRevision>(){

                @Override
                public int compare(TreeNodeOnVcsRevision o1, TreeNodeOnVcsRevision o2) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    VcsFileRevision revision1 = o1.myRevision;
                    VcsFileRevision revision2 = o2.myRevision;
                    if (revision1 == null) {
                        return -1;
                    }
                    if (revision2 == null) {
                        return 1;
                    }
                    return comparator.compare(revision1, revision2);
                }
            };
        }

        public String getName() {
            return this.myBaseColumn.getName();
        }

        public Class getColumnClass() {
            return this.myBaseColumn.getColumnClass();
        }

        public boolean isCellEditable(TreeNodeOnVcsRevision o) {
            return this.myBaseColumn.isCellEditable((Object)o.myRevision);
        }

        public void setValue(TreeNodeOnVcsRevision o, Object aValue) {
            this.myBaseColumn.setValue((Object)o.myRevision, aValue);
        }

        public TableCellRenderer getRenderer(TreeNodeOnVcsRevision p0) {
            return this.myBaseColumn.getRenderer((Object)p0.myRevision);
        }

        public TableCellEditor getEditor(TreeNodeOnVcsRevision item) {
            return this.myBaseColumn.getEditor((Object)item.myRevision);
        }

        public String getMaxStringValue() {
            return this.myBaseColumn.getMaxStringValue();
        }

        public int getAdditionalWidth() {
            return this.myBaseColumn.getAdditionalWidth();
        }

        public int getWidth(JTable table) {
            return this.myBaseColumn.getWidth(table);
        }

        public void setName(String s) {
            this.myBaseColumn.setName(s);
        }

        public MyColumnWrapper(ColumnInfo<VcsFileRevision, T> additionalColunm) {
            super(additionalColunm.getName());
            this.myBaseColumn = additionalColunm;
        }

        public boolean shouldBeShownIsTheTree() {
            return true;
        }

        public boolean shouldBeShownIsTheTable() {
            return true;
        }

        public Object valueOf(TreeNodeOnVcsRevision o) {
            return this.myBaseColumn.valueOf((Object)o.myRevision);
        }

        public ColumnInfo getOriginalColumn() {
            return this.myBaseColumn;
        }
    }

    static abstract class VcsColumnInfo<T extends Comparable>
    extends DualViewColumnInfo<VcsFileRevision, String>
    implements Comparator<VcsFileRevision> {
        public VcsColumnInfo(String name) {
            super(name);
        }

        protected abstract T getDataOf(VcsFileRevision var1);

        public Comparator<VcsFileRevision> getComparator() {
            return this;
        }

        public String valueOf(VcsFileRevision object) {
            T result = this.getDataOf(object);
            return result == null ? "" : result.toString();
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return this.compareObjects((Comparable)this.getDataOf(o1), (Comparable)this.getDataOf(o2));
        }

        private int compareObjects(Comparable data1, Comparable data2) {
            if (data1 == data2) {
                return 0;
            }
            if (data1 == null) {
                return -1;
            }
            if (data2 == null) {
                return 1;
            }
            return data1.compareTo(data2);
        }

        public boolean shouldBeShownIsTheTree() {
            return true;
        }

        public boolean shouldBeShownIsTheTable() {
            return true;
        }
    }

    abstract class AbstractActionForSomeSelection
    extends AnAction
    implements DumbAware {
        private final int mySuitableSelectedElements;
        private final FileHistoryPanelImpl mySelectionProvider;

        public AbstractActionForSomeSelection(String name, @NonNls String description, String iconName, int suitableSelectionSize, FileHistoryPanelImpl tableProvider) {
            super(name, description, IconLoader.getIcon((String)("/actions/" + iconName + ".png")));
            this.mySuitableSelectedElements = suitableSelectionSize;
            this.mySelectionProvider = tableProvider;
        }

        protected abstract void actionPerformed();

        public boolean isEnabled() {
            return this.mySelectionProvider.getSelection().size() == this.mySuitableSelectedElements;
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.actionPerformed();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            presentation.setEnabled(this.isEnabled());
        }
    }

    static class TreeNodeOnVcsRevision
    extends DefaultMutableTreeNode
    implements VcsFileRevision,
    DualTreeElement {
        private final VcsFileRevision myRevision;

        public TreeNodeOnVcsRevision(VcsFileRevision revision, List<TreeItem<VcsFileRevision>> roots) {
            this.myRevision = revision == null ? VcsFileRevision.NULL : revision;
            for (TreeItem<VcsFileRevision> root : roots) {
                this.add(new TreeNodeOnVcsRevision((VcsFileRevision)root.getData(), root.getChildren()));
            }
        }

        public String getAuthor() {
            return this.myRevision.getAuthor();
        }

        public String getCommitMessage() {
            return this.myRevision.getCommitMessage();
        }

        public void loadContent() throws VcsException {
            this.myRevision.loadContent();
        }

        public VcsRevisionNumber getRevisionNumber() {
            return this.myRevision.getRevisionNumber();
        }

        public Date getRevisionDate() {
            return this.myRevision.getRevisionDate();
        }

        public String getBranchName() {
            return this.myRevision.getBranchName();
        }

        public byte[] getContent() throws IOException {
            return this.myRevision.getContent();
        }

        @Override
        public String toString() {
            return this.getRevisionNumber().asString();
        }

        public boolean shouldBeInTheFlatView() {
            return this.myRevision != VcsFileRevision.NULL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNodeOnVcsRevision that = (TreeNodeOnVcsRevision)o;
            return !(this.myRevision != null ? !this.myRevision.getRevisionNumber().equals(that.myRevision.getRevisionNumber()) : that.myRevision != null);
        }

        public int hashCode() {
            return this.myRevision != null ? this.myRevision.getRevisionNumber().hashCode() : 0;
        }
    }

    private static class LoadedContentRevision
    implements ContentRevision {
        private final FilePath myFile;
        private final VcsFileRevision myRevision;

        private LoadedContentRevision(FilePath file, VcsFileRevision revision) {
            this.myFile = file;
            this.myRevision = revision;
        }

        public String getContent() throws VcsException {
            this.myRevision.loadContent();
            try {
                return ((Object)LoadTextUtil.getTextByBinaryPresentation(this.myRevision.getContent(), this.myFile.getVirtualFile(), false)).toString();
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myFile;
            if (filePath == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision.getFile must not return null");
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision.getRevisionNumber must not return null");
            }
            return vcsRevisionNumber;
        }
    }

    private class MyAnnotateAction
    extends AnAction {
        public MyAnnotateAction() {
            super(VcsBundle.message((String)"annotate.action.name", (Object[])new Object[0]), VcsBundle.message((String)"annotate.action.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/annotate.png"));
        }

        private String key(VirtualFile vf, VcsFileRevision revision) {
            return vf.getPath();
        }

        public void update(AnActionEvent e) {
            boolean enabled;
            VirtualFile revVFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
            VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
            FileType fileType = revVFile == null ? null : revVFile.getFileType();
            boolean bl = enabled = revision != null && revVFile != null && !fileType.isBinary();
            if (enabled) {
                ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)FileHistoryPanelImpl.this.myProject);
                enabled &= !((ProjectLevelVcsManagerImpl)plVcsManager).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE).isInProgress(this.key(revVFile, revision));
            }
            e.getPresentation().setEnabled(enabled && FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(revision) && FileHistoryPanelImpl.this.myAnnotationProvider != null && FileHistoryPanelImpl.this.myAnnotationProvider.isAnnotationValid(revision));
        }

        public void actionPerformed(AnActionEvent e) {
            final VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
            final VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
            if (revision == null || revisionVirtualFile == null) {
                return;
            }
            final BackgroundableActionEnabledHandler handler = ((ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)FileHistoryPanelImpl.this.myProject)).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE);
            handler.register(this.key(revisionVirtualFile, revision));
            final Ref fileAnnotationRef = new Ref();
            final Ref exceptionRef = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(FileHistoryPanelImpl.this.myProject, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyAnnotateAction$1.run must not be null");
                    }
                    try {
                        fileAnnotationRef.set((Object)FileHistoryPanelImpl.this.myAnnotationProvider.annotate(revisionVirtualFile, revision));
                    }
                    catch (VcsException e) {
                        exceptionRef.set((Object)e);
                    }
                }

                public void onCancel() {
                    this.onSuccess();
                }

                public void onSuccess() {
                    handler.completed(MyAnnotateAction.this.key(revisionVirtualFile, revision));
                    if (!exceptionRef.isNull()) {
                        AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)((Object)exceptionRef.get()), VcsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]));
                    }
                    if (fileAnnotationRef.isNull()) {
                        return;
                    }
                    AbstractVcsHelper.getInstance((Project)this.myProject).showAnnotation((FileAnnotation)fileAnnotationRef.get(), revisionVirtualFile);
                }
            });
        }
    }

    private class MyGetVersionAction
    extends AbstractActionForSomeSelection {
        public MyGetVersionAction() {
            super(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.message((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), "get", 1, FileHistoryPanelImpl.this);
        }

        @Override
        public void update(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.getVirtualParent() == null) {
                Presentation presentation = e.getPresentation();
                presentation.setVisible(false);
                presentation.setEnabled(false);
            } else {
                super.update(e);
            }
        }

        @Override
        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(FileHistoryPanelImpl.this.getFirstSelectedRevision());
        }

        @Override
        protected void actionPerformed() {
            VcsFileRevision revision = FileHistoryPanelImpl.this.getFirstSelectedRevision();
            if (FileHistoryPanelImpl.this.getVirtualFile() != null && !new ReplaceFileConfirmationDialog(FileHistoryPanelImpl.this.myProject, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0])).confirmFor(new VirtualFile[]{FileHistoryPanelImpl.this.getVirtualFile()})) {
                return;
            }
            try {
                revision.loadContent();
            }
            catch (VcsException e) {
                Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.load.version", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]));
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            this.getVersion(revision);
            this.refreshFile(revision);
        }

        private void refreshFile(VcsFileRevision revision) {
            Runnable refresh = null;
            final VirtualFile vf = FileHistoryPanelImpl.this.getVirtualFile();
            if (vf == null) {
                final LocalHistoryAction action = this.startLocalHistoryAction(revision);
                final VirtualFile vp = FileHistoryPanelImpl.this.getVirtualParent();
                if (vp != null) {
                    refresh = new Runnable(){

                        @Override
                        public void run() {
                            vp.refresh(false, true, new Runnable(){

                                @Override
                                public void run() {
                                    FileHistoryPanelImpl.this.myFilePath.refresh();
                                    action.finish();
                                }
                            });
                        }
                    };
                }
            } else {
                refresh = new Runnable(){

                    @Override
                    public void run() {
                        vf.refresh(false, false);
                    }
                };
            }
            if (refresh != null) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(refresh, "Refreshing files...", false, FileHistoryPanelImpl.this.myProject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getVersion(final VcsFileRevision revision) {
            byte[] revisionContent;
            VirtualFile file = FileHistoryPanelImpl.this.getVirtualFile();
            if (file != null && !file.isWritable() && ReadonlyStatusHandler.getInstance((Project)FileHistoryPanelImpl.this.myProject).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                return;
            }
            LocalHistoryAction action = file != null ? this.startLocalHistoryAction(revision) : LocalHistoryAction.NULL;
            try {
                revision.loadContent();
                revisionContent = revision.getContent();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
            catch (VcsException e) {
                Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                return;
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            final byte[] finalRevisionContent = revisionContent;
            try {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(FileHistoryPanelImpl.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MyGetVersionAction.this.write(finalRevisionContent);
                                }
                                catch (IOException e) {
                                    Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                                }
                            }
                        }, MyGetVersionAction.this.createGetActionTitle(revision), null);
                    }
                });
                if (file != null) {
                    VcsDirtyScopeManager.getInstance((Project)FileHistoryPanelImpl.this.myProject).fileDirty(file);
                }
            }
            finally {
                action.finish();
            }
        }

        private LocalHistoryAction startLocalHistoryAction(VcsFileRevision revision) {
            return LocalHistory.startAction((Project)FileHistoryPanelImpl.this.myProject, (String)this.createGetActionTitle(revision));
        }

        private String createGetActionTitle(VcsFileRevision revision) {
            return VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{this.getIOFile().getAbsolutePath(), revision.getRevisionNumber()});
        }

        private File getIOFile() {
            return FileHistoryPanelImpl.this.myFilePath.getIOFile();
        }

        private void write(byte[] revision) throws IOException {
            if (FileHistoryPanelImpl.this.getVirtualFile() == null) {
                this.writeContentToIOFile(revision);
            } else {
                Document document = FileHistoryPanelImpl.this.myFilePath.getDocument();
                if (document == null) {
                    this.writeContentToFile(revision);
                } else {
                    this.writeContentToDocument(document, revision);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeContentToIOFile(byte[] revisionContent) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(this.getIOFile());
            try {
                outputStream.write(revisionContent);
            }
            finally {
                outputStream.close();
            }
        }

        private void writeContentToFile(byte[] revision) throws IOException {
            FileHistoryPanelImpl.this.getVirtualFile().setBinaryContent(revision);
        }

        private void writeContentToDocument(final Document document, byte[] revisionContent) throws IOException {
            final String content = StringUtil.convertLineSeparators((String)new String(revisionContent, FileHistoryPanelImpl.this.myFilePath.getCharset().name()));
            CommandProcessor.getInstance().executeCommand(FileHistoryPanelImpl.this.myProject, new Runnable(){

                @Override
                public void run() {
                    document.replaceString(0, document.getTextLength(), (CharSequence)content);
                }
            }, VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), null);
        }
    }

    private class MyDiffAction
    extends AbstractActionForSomeSelection {
        public MyDiffAction() {
            super(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]), VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]), "diff", 2, FileHistoryPanelImpl.this);
        }

        @Override
        protected void actionPerformed() {
            VcsRevisionNumber currentRevisionNumber;
            List sel = FileHistoryPanelImpl.this.getSelection();
            int selectionSize = sel.size();
            if (selectionSize > 1) {
                FileHistoryPanelImpl.this.showDifferences(FileHistoryPanelImpl.this.myProject, (VcsFileRevision)sel.get(0), (VcsFileRevision)sel.get(sel.size() - 1));
            } else if (selectionSize == 1 && (currentRevisionNumber = FileHistoryPanelImpl.this.myHistorySession.getCurrentRevisionNumber()) != null) {
                FileHistoryPanelImpl.this.showDifferences(FileHistoryPanelImpl.this.myProject, FileHistoryPanelImpl.this.getFirstSelectedRevision(), (VcsFileRevision)new CurrentRevision(FileHistoryPanelImpl.this.myFilePath.getVirtualFile(), currentRevisionNumber));
            }
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (selectionSize == 1) {
                e.getPresentation().setText(VcsBundle.message((String)"action.name.compare.with.local", (Object[])new Object[0]));
                e.getPresentation().setDescription(VcsBundle.message((String)"action.description.compare.with.local", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]));
                e.getPresentation().setDescription(VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]));
            }
        }

        @Override
        public boolean isEnabled() {
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (selectionSize == 1) {
                return this.isDiffWithCurrentEnabled();
            }
            if (selectionSize > 1) {
                return this.isDiffEnabled();
            }
            return false;
        }

        private boolean isDiffEnabled() {
            List sel = FileHistoryPanelImpl.this.getSelection();
            return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(0)) && FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(sel.size() - 1));
        }

        private boolean isDiffWithCurrentEnabled() {
            if (FileHistoryPanelImpl.this.myHistorySession.getCurrentRevisionNumber() == null) {
                return false;
            }
            if (FileHistoryPanelImpl.this.myFilePath.getVirtualFile() == null) {
                return false;
            }
            return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(FileHistoryPanelImpl.this.getFirstSelectedRevision());
        }
    }

    private class MyShowAsTreeAction
    extends ToggleAction
    implements DumbAware {
        public MyShowAsTreeAction() {
            super(VcsBundle.message((String)"action.name.show.files.as.tree", (Object[])new Object[0]), null, Icons.SMALL_VCS_CONFIGURABLE);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE = state;
            FileHistoryPanelImpl.this.chooseView();
        }
    }

    private static class MessageColumnInfo
    extends VcsColumnInfo<String> {
        private final MessageRenderer myRenderer;

        public MessageColumnInfo(Project project) {
            super(COMMIT_MESSAGE_TITLE);
            this.myRenderer = new MessageRenderer(project);
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            String originalMessage = object.getCommitMessage();
            if (originalMessage != null) {
                String commitMessage = originalMessage.trim();
                int index13 = commitMessage.indexOf(13);
                int index10 = commitMessage.indexOf(10);
                if (index10 < 0 && index13 < 0) {
                    return commitMessage;
                }
                return commitMessage.substring(0, MessageColumnInfo.getSuitableIndex(index10, index13)) + "...";
            }
            return "";
        }

        private static int getSuitableIndex(int index10, int index13) {
            if (index10 < 0) {
                return index13;
            }
            if (index13 < 0) {
                return index10;
            }
            return Math.min(index10, index13);
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'a', (int)125);
        }

        public TableCellRenderer getRenderer(VcsFileRevision p0) {
            return this.myRenderer;
        }
    }

    private static class MessageRenderer
    extends ColoredTableCellRenderer {
        private final IssueLinkRenderer myIssueLinkRenderer;

        public MessageRenderer(Project project) {
            this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setOpaque(selected);
            String message = (String)value;
            this.myIssueLinkRenderer.appendTextWithLinks(message);
            this.setToolTipText(message);
        }

        protected void paintComponent(Graphics g) {
            this.doPaint(g);
        }
    }
}

