/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AllVcses
implements AllVcsesI,
Disposable {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.AllVcses");
    private final Map<String, AbstractVcs> myVcses;
    private final Object myLock;
    private final Project myProject;
    private final Map<String, VcsEP> myExtensions;

    private AllVcses(Project project) {
        this.myProject = project;
        this.myVcses = new HashMap<String, AbstractVcs>();
        this.myLock = new Object();
        VcsEP[] vcsEPs = (VcsEP[])Extensions.getExtensions(VcsEP.EP_NAME, (AreaInstance)this.myProject);
        this.myExtensions = new HashMap<String, VcsEP>();
        for (VcsEP vcsEP : vcsEPs) {
            this.myExtensions.put(vcsEP.name, vcsEP);
        }
        for (VcsEP ep : this.myExtensions.values()) {
            this.addVcs(ep.getVcs(this.myProject));
        }
    }

    public static AllVcsesI getInstance(Project project) {
        return (AllVcsesI)ServiceManager.getService((Project)project, AllVcsesI.class);
    }

    private void addVcs(AbstractVcs vcs) {
        this.registerVcs(vcs);
        this.myVcses.put(vcs.getName(), vcs);
    }

    private void registerVcs(AbstractVcs vcs) {
        try {
            vcs.loadSettings();
            vcs.doStart();
        }
        catch (VcsException e) {
            this.LOG.debug((Throwable)e);
        }
        vcs.getProvidedStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/projectlevelman/AllVcses.registerManually must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.addVcs(vcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/projectlevelman/AllVcses.unregisterManually must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.unregisterVcs(vcs);
            this.myVcses.remove(vcs.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractVcs getByName(String name) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myVcses.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (AbstractVcs vcs : this.myVcses.values()) {
                this.unregisterVcs(vcs);
            }
        }
    }

    private void unregisterVcs(AbstractVcs vcs) {
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            this.LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myVcses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractVcs[] getAll() {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs[] vcses = this.myVcses.values().toArray(new AbstractVcs[this.myVcses.size()]);
            Arrays.sort(vcses, new Comparator<AbstractVcs>(){

                @Override
                public int compare(AbstractVcs o1, AbstractVcs o2) {
                    return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
                }
            });
            return vcses;
        }
    }
}

