/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public abstract class UpdateOrStatusOptionsDialog
extends OptionsDialog {
    private final JComponent myMainPanel;
    private final Map<AbstractVcs, Configurable> myEnvToConfMap = new HashMap<AbstractVcs, Configurable>();
    protected final Project myProject;

    public UpdateOrStatusOptionsDialog(Project project, Map<Configurable, AbstractVcs> confs) {
        super(project);
        this.setTitle(this.getRealTitle());
        this.myProject = project;
        if (confs.size() == 1) {
            this.myMainPanel = new JPanel(new BorderLayout());
            Configurable configurable = confs.keySet().iterator().next();
            this.addComponent(confs.get(configurable), configurable, "Center");
            this.myMainPanel.add((Component)new JSeparator(), "South");
        } else {
            this.myMainPanel = new JTabbedPane();
            ArrayList<AbstractVcs> vcses = new ArrayList<AbstractVcs>(confs.values());
            Collections.sort(vcses, new Comparator<AbstractVcs>(){

                @Override
                public int compare(AbstractVcs o1, AbstractVcs o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            Map<AbstractVcs, Configurable> vcsToConfigurable = UpdateOrStatusOptionsDialog.revertMap(confs);
            for (AbstractVcs vcs : vcses) {
                this.addComponent(vcs, vcsToConfigurable.get(vcs), vcs.getDisplayName());
            }
        }
        this.init();
    }

    private static Map<AbstractVcs, Configurable> revertMap(Map<Configurable, AbstractVcs> confs) {
        HashMap<AbstractVcs, Configurable> result = new HashMap<AbstractVcs, Configurable>();
        for (Configurable configurable : confs.keySet()) {
            result.put(confs.get(configurable), configurable);
        }
        return result;
    }

    protected abstract String getRealTitle();

    private void addComponent(AbstractVcs vcs, Configurable configurable, String constraint) {
        this.myEnvToConfMap.put(vcs, configurable);
        this.myMainPanel.add((Component)configurable.createComponent(), constraint);
        configurable.reset();
    }

    protected void doOKAction() {
        for (Configurable configurable : this.myEnvToConfMap.values()) {
            try {
                configurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"messge.text.cannot.save.settings", (Object[])new Object[]{e.getLocalizedMessage()}), (String)this.getRealTitle());
                return;
            }
        }
        super.doOKAction();
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected Action[] createActions() {
        for (Configurable conf : this.myEnvToConfMap.values()) {
            if (conf.getHelpTopic() == null) continue;
            return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        }
        return super.createActions();
    }

    protected void doHelpAction() {
        String helpTopic = null;
        Collection<Configurable> v = this.myEnvToConfMap.values();
        Configurable[] configurables = v.toArray(new Configurable[v.size()]);
        if (this.myMainPanel instanceof JTabbedPane) {
            int tabIndex = ((JTabbedPane)this.myMainPanel).getSelectedIndex();
            if (tabIndex >= 0 && tabIndex < configurables.length) {
                helpTopic = configurables[tabIndex].getHelpTopic();
            }
        } else {
            helpTopic = configurables[0].getHelpTopic();
        }
        if (helpTopic != null) {
            HelpManager.getInstance().invokeHelp(helpTopic);
        } else {
            super.doHelpAction();
        }
    }
}

