/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.EventDispatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HttpFileSystemImpl
extends HttpFileSystem {
    private final RemoteFileManager myRemoteFileManager;
    private final EventDispatcher<HttpVirtualFileListener> myDispatcher = EventDispatcher.create(HttpVirtualFileListener.class);
    private final List<RemoteContentProvider> myProviders = new ArrayList<RemoteContentProvider>();
    private final DefaultRemoteContentProvider myDefaultRemoteContentProvider;

    public HttpFileSystemImpl() {
        this.myRemoteFileManager = new RemoteFileManager(this);
        this.myDefaultRemoteContentProvider = new DefaultRemoteContentProvider();
    }

    public static HttpFileSystemImpl getInstanceImpl() {
        return (HttpFileSystemImpl)HttpFileSystemImpl.getInstance();
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.findFileByPath must not be null");
        }
        return this.findFileByPath(path, false);
    }

    public VirtualFile findFileByPath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.findFileByPath must not be null");
        }
        try {
            String url = VirtualFileManager.constructUrl((String)"http", (String)path);
            return this.myRemoteFileManager.getOrCreateFile(url, path, isDirectory);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public RemoteContentProvider findContentProvider(@NotNull String url) {
        RemoteContentProvider remoteContentProvider;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.findContentProvider must not be null");
        }
        for (RemoteContentProvider provider : this.myProviders) {
            if (!provider.canProvideContent(url)) continue;
            remoteContentProvider = provider;
            if (remoteContentProvider == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.findContentProvider must not return null");
            return remoteContentProvider;
        }
        remoteContentProvider = this.myDefaultRemoteContentProvider;
        if (remoteContentProvider != null) return remoteContentProvider;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.findContentProvider must not return null");
    }

    public boolean isFileDownloaded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.isFileDownloaded must not be null");
        }
        return file instanceof HttpVirtualFile && ((HttpVirtualFile)file).getFileInfo().getState() == RemoteFileState.DOWNLOADED;
    }

    public void addRemoteContentProvider(final @NotNull RemoteContentProvider provider, @NotNull Disposable parentDisposable) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addRemoteContentProvider must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addRemoteContentProvider must not be null");
        }
        this.addRemoteContentProvider(provider);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                HttpFileSystemImpl.this.removeRemoteContentProvider(provider);
            }
        });
    }

    public void addRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addRemoteContentProvider must not be null");
        }
        this.myProviders.add(provider);
    }

    public void removeRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.removeRemoteContentProvider must not be null");
        }
        this.myProviders.remove(provider);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addFileListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addFileListener(final @NotNull HttpVirtualFileListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addFileListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.addFileListener must not be null");
        }
        this.addFileListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                HttpFileSystemImpl.this.removeFileListener(listener);
            }
        });
    }

    public void removeFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.removeFileListener must not be null");
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void fireFileDownloaded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.fireFileDownloaded must not be null");
        }
        ((HttpVirtualFileListener)this.myDispatcher.getMulticaster()).fileDownloaded(file);
    }

    public void disposeComponent() {
        this.myRemoteFileManager.getStorage().deleteDownloadedFiles();
    }

    public void initComponent() {
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.createChildDirectory must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.createChildFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.deleteFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.moveFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.copyFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.renameFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getProtocol() {
        if ("http" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.getProtocol must not return null");
        }
        return "http";
    }

    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.extractPresentableUrl must not be null");
        }
        return VirtualFileManager.constructUrl((String)"http", (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.refreshAndFindFileByPath must not be null");
        }
        return this.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String getComponentName() {
        if ("HttpFileSystem" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/http/HttpFileSystemImpl.getComponentName must not return null");
        }
        return "HttpFileSystem";
    }
}

