/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.watcher.ChangeKind;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    @NonNls
    public static final String PROPERTY_WATCHER_DISABLED = "filewatcher.disabled";
    @NonNls
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.local.FileWatcher");
    @NonNls
    private static final String GIVEUP_COMMAND = "GIVEUP";
    @NonNls
    private static final String RESET_COMMAND = "RESET";
    @NonNls
    private static final String UNWATCHEABLE_COMMAND = "UNWATCHEABLE";
    @NonNls
    private static final String ROOTS_COMMAND = "ROOTS";
    @NonNls
    private static final String REMAP_COMMAND = "REMAP";
    @NonNls
    private static final String EXIT_COMMAND = "EXIT";
    @NonNls
    private static final String MESSAGE_COMMAND = "MESSAGE";
    private final Object LOCK = new Object();
    private List<String> myDirtyPaths = new ArrayList<String>();
    private List<String> myDirtyRecursivePaths = new ArrayList<String>();
    private List<String> myDirtyDirs = new ArrayList<String>();
    private List<String> myManualWatchRoots = new ArrayList<String>();
    private List<Pair<String, String>> myMapping = new ArrayList<Pair<String, String>>();
    private List<String> myRecursiveWatchRoots = new ArrayList<String>();
    private List<String> myFlatWatchRoots = new ArrayList<String>();
    private Process notifierProcess;
    private BufferedReader notifierReader;
    private BufferedWriter notifierWriter;
    private static final FileWatcher ourInstance = new FileWatcher();
    private int attemptCount = 0;
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private boolean isShuttingDown = false;

    public static FileWatcher getInstance() {
        return ourInstance;
    }

    private FileWatcher() {
        try {
            if (!"true".equals(System.getProperty(PROPERTY_WATCHER_DISABLED))) {
                this.startupProcess();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.notifierProcess != null) {
            LOG.info("Native file watcher is operational.");
            new WatchForChangesThread().start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    FileWatcher.this.isShuttingDown = true;
                    FileWatcher.this.shutdownProcess();
                }
            }, "FileWatcher shutdown hook"));
        } else {
            LOG.info("Native file watcher failed to startup.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDirtyPaths() {
        Object object = this.LOCK;
        synchronized (object) {
            List<String> result = this.myDirtyPaths;
            this.myDirtyPaths = new ArrayList<String>();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDirtyRecursivePaths() {
        Object object = this.LOCK;
        synchronized (object) {
            List<String> result = this.myDirtyRecursivePaths;
            this.myDirtyRecursivePaths = new ArrayList<String>();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDirtyDirs() {
        Object object = this.LOCK;
        synchronized (object) {
            List<String> result = this.myDirtyDirs;
            this.myDirtyDirs = new ArrayList<String>();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManualWatchRoots() {
        Object object = this.LOCK;
        synchronized (object) {
            return Collections.unmodifiableList(this.myManualWatchRoots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWatchRoots(List<String> recursive, List<String> flat) {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                if (((Object)this.myRecursiveWatchRoots).equals(recursive) && ((Object)this.myFlatWatchRoots).equals(flat)) {
                    return;
                }
                this.myRecursiveWatchRoots = recursive;
                this.myFlatWatchRoots = flat;
                if (this.isAlive()) {
                    this.writeLine(ROOTS_COMMAND);
                    this.myMapping.clear();
                    for (String path : recursive) {
                        this.writeLine(path);
                    }
                    for (String path : flat) {
                        this.writeLine("|" + path);
                    }
                    this.writeLine("#");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private boolean isAlive() {
        if (!this.isOperational()) {
            return false;
        }
        try {
            this.notifierProcess.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setManualWatchRoots(List<String> roots) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myManualWatchRoots = roots;
        }
    }

    private void startupProcess() throws IOException {
        if (this.isShuttingDown) {
            return;
        }
        if (this.attemptCount++ > 10) {
            throw new IOException("Can't launch process anymore");
        }
        this.shutdownProcess();
        String executableName = SystemInfo.isWindows ? "fsnotifier.exe" : "fsnotifier";
        String alternatePathToFilewatcherExecutable = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (alternatePathToFilewatcherExecutable != null && !new File(alternatePathToFilewatcherExecutable).exists()) {
            alternatePathToFilewatcherExecutable = null;
        }
        String pathToExecutable = alternatePathToFilewatcherExecutable != null ? FileUtil.toSystemDependentName((String)alternatePathToFilewatcherExecutable) : PathManager.getBinPath() + File.separatorChar + executableName;
        this.notifierProcess = Runtime.getRuntime().exec(new String[]{pathToExecutable});
        this.notifierReader = new BufferedReader(new InputStreamReader(this.notifierProcess.getInputStream()));
        this.notifierWriter = new BufferedWriter(new OutputStreamWriter(this.notifierProcess.getOutputStream()));
    }

    private void shutdownProcess() {
        if (this.notifierProcess != null) {
            if (this.isAlive()) {
                try {
                    this.writeLine(EXIT_COMMAND);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.notifierProcess = null;
            this.notifierReader = null;
            this.notifierWriter = null;
        }
    }

    public boolean isOperational() {
        return this.notifierProcess != null;
    }

    private String ensureEndsWithSlash(String path) {
        if (path.endsWith("/") || path.endsWith(File.separator)) {
            return path;
        }
        return path + '/';
    }

    private void writeLine(String line) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("to fsnotifier: " + line);
            }
            this.notifierWriter.write(line);
            this.notifierWriter.newLine();
            this.notifierWriter.flush();
        }
        catch (IOException e) {
            try {
                this.notifierProcess.exitValue();
            }
            catch (IllegalThreadStateException e1) {
                throw e;
            }
            this.notifierProcess = null;
            this.notifierWriter = null;
            this.notifierReader = null;
        }
    }

    @Nullable
    private String readLine() throws IOException {
        if (this.notifierReader == null) {
            return null;
        }
        String line = this.notifierReader.readLine();
        if (LOG.isDebugEnabled()) {
            LOG.debug("fsnotifier says: " + line);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWatcheable(String path) {
        if (path == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (String root : this.myRecursiveWatchRoots) {
                if (!FileUtil.startsWith((String)path, (String)root)) continue;
                return true;
            }
            for (String root : this.myFlatWatchRoots) {
                if (FileUtil.pathsEqual((String)path, (String)root)) {
                    return true;
                }
                File parentFile = new File(path).getParentFile();
                if (parentFile == null || !FileUtil.pathsEqual((String)parentFile.getPath(), (String)root)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPathChange(ChangeKind changeKind, String path) {
        Object object = this.LOCK;
        synchronized (object) {
            switch (changeKind) {
                case STATS: 
                case CHANGE: {
                    this.addPath(path, this.myDirtyPaths);
                    break;
                }
                case CREATE: 
                case DELETE: {
                    File parentFile = new File(path).getParentFile();
                    if (parentFile != null) {
                        this.addPath(parentFile.getPath(), this.myDirtyPaths);
                        break;
                    }
                    this.addPath(path, this.myDirtyPaths);
                    break;
                }
                case DIRTY: {
                    this.addPath(path, this.myDirtyDirs);
                    break;
                }
                case RECDIRTY: {
                    this.addPath(path, this.myDirtyRecursivePaths);
                    break;
                }
                case RESET: {
                    this.reset();
                }
            }
        }
    }

    private void addPath(String path, List<String> list) {
        list.add(path);
        for (Pair<String, String> map : this.myMapping) {
            if (FileUtil.startsWith((String)path, (String)((String)map.getFirst()))) {
                list.add((String)map.getSecond() + path.substring(((String)map.getFirst()).length()));
                continue;
            }
            if (!FileUtil.startsWith((String)path, (String)((String)map.getSecond()))) continue;
            list.add((String)map.getFirst() + path.substring(((String)map.getSecond()).length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        ManagingFS fs = ManagingFS.getInstance();
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyPaths.clear();
            this.myDirtyDirs.clear();
            this.myDirtyRecursivePaths.clear();
            for (VirtualFile root : fs.getLocalRoots()) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
        }
    }

    private class WatchForChangesThread
    extends Thread {
        public WatchForChangesThread() {
            super("WatchForChangesThread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!ApplicationManager.getApplication().isDisposeInProgress()) {
                    String pathB;
                    String pathA;
                    HashSet<Pair> pairs;
                    block19: {
                        String path;
                        ArrayList<String> roots;
                        if (FileWatcher.this.notifierProcess == null) return;
                        if (FileWatcher.this.isShuttingDown) {
                            return;
                        }
                        String command = FileWatcher.this.readLine();
                        if (command == null) {
                            FileWatcher.this.startupProcess();
                            continue;
                        }
                        if (FileWatcher.GIVEUP_COMMAND.equals(command)) {
                            LOG.info("Filewatcher gives up to operate on this platform");
                            FileWatcher.this.shutdownProcess();
                            return;
                        }
                        if (FileWatcher.RESET_COMMAND.equals(command)) {
                            FileWatcher.this.reset();
                            continue;
                        }
                        if (FileWatcher.UNWATCHEABLE_COMMAND.equals(command)) {
                            roots = new ArrayList<String>();
                        } else {
                            if (FileWatcher.MESSAGE_COMMAND.equals(command)) {
                                String message = FileWatcher.this.readLine();
                                if (message == null) {
                                    return;
                                }
                                Notifications.Bus.notify((Notification)new Notification("System Messages", "File Watcher", message, NotificationType.WARNING, new NotificationListener(){

                                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                                        if (notification == null) {
                                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/FileWatcher$WatchForChangesThread$1.hyperlinkUpdate must not be null");
                                        }
                                        if (event == null) {
                                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/FileWatcher$WatchForChangesThread$1.hyperlinkUpdate must not be null");
                                        }
                                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                            BrowserUtil.launchBrowser((String)event.getURL().toExternalForm());
                                        }
                                    }
                                }));
                                continue;
                            }
                            if (FileWatcher.REMAP_COMMAND.equals(command)) {
                                pairs = new HashSet<Pair>();
                                break block19;
                            } else {
                                String path2 = FileWatcher.this.readLine();
                                if (path2 == null) {
                                    FileWatcher.this.startupProcess();
                                    continue;
                                }
                                if (FileWatcher.this.isWatcheable(path2)) {
                                    try {
                                        FileWatcher.this.onPathChange(ChangeKind.valueOf((String)command), path2);
                                        continue;
                                    }
                                    catch (IllegalArgumentException e) {
                                        LOG.error("Illegal watcher command: " + command);
                                        continue;
                                    }
                                }
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("not watcheable, filtered: " + path2);
                                continue;
                            }
                        }
                        while ((path = FileWatcher.this.readLine()) != null && !"#".equals(path)) {
                            roots.add(path);
                        }
                        FileWatcher.this.setManualWatchRoots(roots);
                        continue;
                    }
                    while ((pathA = FileWatcher.this.readLine()) != null && !"#".equals(pathA) && (pathB = FileWatcher.this.readLine()) != null && !"#".equals(pathB)) {
                        pairs.add(new Pair((Object)FileWatcher.this.ensureEndsWithSlash(pathA), (Object)FileWatcher.this.ensureEndsWithSlash(pathB)));
                    }
                    FileWatcher.this.myMapping.clear();
                    FileWatcher.this.myMapping.addAll(pairs);
                }
                return;
            }
            catch (IOException e) {
                FileWatcher.this.reset();
                FileWatcher.this.shutdownProcess();
                LOG.info("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }
    }
}

