/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class RequestFocusInToolWindowCmd
extends FinalizableCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd");
    private final ToolWindowImpl myToolWindow;
    private final FocusWatcher myFocusWatcher;
    private final boolean myForced;
    private IdeFocusManager myFocusManager;
    private Expirable myTimestamp;

    public RequestFocusInToolWindowCmd(IdeFocusManager focusManager, ToolWindowImpl toolWindow, FocusWatcher focusWatcher, Runnable finishCallBack, boolean forced) {
        super(finishCallBack);
        this.myToolWindow = toolWindow;
        this.myFocusWatcher = focusWatcher;
        this.myForced = forced;
        this.myFocusManager = focusManager;
        this.myTimestamp = this.myFocusManager.getTimestamp(true);
    }

    @Override
    public final void run() {
        this.myToolWindow.getActivation().doWhenDone(new Runnable(){

            @Override
            public void run() {
                RequestFocusInToolWindowCmd.this.processRequestFocus();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestFocus() {
        try {
            if (this.myTimestamp.isExpired()) {
                return;
            }
            Component preferredFocusedComponent = this.myFocusWatcher.getFocusedComponent();
            if (preferredFocusedComponent == null && this.myToolWindow.getContentManager().getSelectedContent() != null && (preferredFocusedComponent = this.myToolWindow.getContentManager().getSelectedContent().getPreferredFocusableComponent()) != null) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent == null && (preferredFocusedComponent = this.myFocusWatcher.getNearestFocusableComponent()) instanceof JComponent) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent != null && !preferredFocusedComponent.isShowing()) {
                preferredFocusedComponent = null;
            }
            if (preferredFocusedComponent == null) {
                JComponent component = this.myToolWindow.getComponent();
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(component);
            }
            if (preferredFocusedComponent != null) {
                this.requestFocus(preferredFocusedComponent).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RequestFocusInToolWindowCmd.this.bringOwnerToFront();
                    }
                });
            } else {
                JComponent componentToFocus = this.myToolWindow.getComponent();
                this.requestFocus(componentToFocus).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RequestFocusInToolWindowCmd.this.bringOwnerToFront();
                    }
                });
            }
        }
        finally {
            this.finish();
        }
    }

    private void bringOwnerToFront() {
        Window activeWindow;
        Window owner = SwingUtilities.getWindowAncestor(this.myToolWindow.getComponent());
        if (owner != null && owner.getFocusOwner() == null && ((activeWindow = this.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            LOG.debug("owner.toFront()");
            owner.toFront();
        }
    }

    private ActionCallback requestFocus(final Component c) {
        ActionCallback result = new ActionCallback();
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (owner != null && owner == c) {
            this.myManager.getFocusManager().requestFocus(new FocusCommand(){

                public ActionCallback run() {
                    return new ActionCallback.Done();
                }
            }, this.myForced).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    RequestFocusInToolWindowCmd.this.updateToolWindow(c);
                }
            }).notify(result);
        } else {
            this.myManager.getFocusManager().requestFocus((FocusCommand)new FocusCommand.ByComponent(c, (Component)this.myToolWindow.getComponent()), this.myForced).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    RequestFocusInToolWindowCmd.this.updateToolWindow(c);
                }
            }).notify(result);
        }
        return result;
    }

    private void updateToolWindow(Component c) {
        if (c.isFocusOwner()) {
            this.myFocusWatcher.setFocusedComponentImpl(c);
            if (this.myToolWindow.isAvailable() && !this.myToolWindow.isActive()) {
                this.myToolWindow.activate(null, true, false);
            }
        }
        this.updateFocusedComponentForWatcher(c);
    }

    private void updateFocusedComponentForWatcher(Component c) {
        WindowWatcher watcher = ((WindowManagerImpl)WindowManager.getInstance()).getWindowWatcher();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    private Window getActiveWindow(Window[] windows) {
        for (int i = 0; i < windows.length; ++i) {
            Window window = windows[i];
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = this.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

