/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.tabs.impl.singleRow.MoreIcon;
import com.intellij.util.ui.BaseButtonBehavior;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class TabContentLayout
extends ContentLayout {
    static final int MORE_ICON_BORDER = 6;
    LayoutData myLastLayout;
    JPopupMenu myPopup;
    final PopupMenuListener myPopupListener;
    ArrayList<ContentTabLabel> myTabs = new ArrayList();
    final Map<Content, ContentTabLabel> myContent2Tabs = new HashMap<Content, ContentTabLabel>();
    BaseLabel myIdLabel;
    private final MoreIcon myMoreIcon = new MoreIcon(){

        protected Rectangle getIconRec() {
            return TabContentLayout.this.myLastLayout.moreRect;
        }

        protected boolean isActive() {
            return TabContentLayout.this.myUi.myWindow.isActive();
        }

        protected int getIconY(Rectangle iconRec) {
            return iconRec.height / 2 - this.getIconHeight() / 2 + 1;
        }
    };

    TabContentLayout(ToolWindowContentUi ui) {
        super(ui);
        this.myPopupListener = new MyPopupListener();
        new BaseButtonBehavior(this.myUi){

            protected void execute(MouseEvent e) {
                Rectangle moreRect;
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                if (TabContentLayout.this.myLastLayout != null && (moreRect = TabContentLayout.this.myLastLayout.moreRect) != null && moreRect.contains(e.getPoint())) {
                    TabContentLayout.this.showPopup();
                }
            }
        };
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false);
        for (int i = 0; i < this.myUi.myManager.getContentCount(); ++i) {
            this.contentAdded(new ContentManagerEvent((Object)this, this.myUi.myManager.getContent(i), i));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    private void showPopup() {
        this.myPopup = new JPopupMenu();
        this.myPopup.addPopupMenuListener(this.myPopupListener);
        ArrayList<ContentTabLabel> tabs = this.myTabs;
        for (final ContentTabLabel each : tabs) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(each.getText());
            if (this.myUi.myManager.isSelected(each.myContent)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabContentLayout.this.myUi.myManager.setSelectedContent(each.myContent, true);
                }
            });
            this.myPopup.add(item);
        }
        this.myPopup.show(this.myUi, this.myLastLayout.moreRect.x, this.myLastLayout.moreRect.y);
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        ContentManager manager = this.myUi.myManager;
        LayoutData data = new LayoutData(this.myUi);
        data.eachX = 0;
        data.eachY = 1;
        this.myIdLabel.setBounds(data.eachX, data.eachY, this.myIdLabel.getPreferredSize().width, bounds.height);
        data.eachX += this.myIdLabel.getPreferredSize().width;
        int tabsStart = data.eachX;
        if (manager.getContentCount() == 0) {
            return;
        }
        Content selected = manager.getSelectedContent();
        if (selected == null) {
            selected = manager.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds.getSize()) && this.myLastLayout.contentCount == manager.getContentCount()) {
            for (ContentTabLabel each : this.myTabs) {
                if (!each.isValid()) break;
                if (each.myContent != selected || each.getBounds().width == 0) continue;
                data = this.myLastLayout;
                data.fullLayout = false;
            }
        }
        if (data.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data.requiredWidth += eachSize.width;
                ++data.requiredWidth;
                data.toLayout.add(eachTab);
            }
            data.moreRectWidth = this.myMoreIcon.getIconWidth() + 12;
            data.toFitWidth = bounds.getSize().width - data.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected);
            while (data.requiredWidth > data.toFitWidth && data.toLayout.size() > 1) {
                if (data.toLayout.get(0) != selectedTab) {
                    this.dropTab(data, data.toLayout.remove(0));
                    continue;
                }
                if (data.toLayout.get(data.toLayout.size() - 1) == selectedTab) break;
                this.dropTab(data, data.toLayout.remove(data.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data.moreRect = null;
            for (ContentTabLabel each : data.toLayout) {
                data.eachY = this.isToDrawTabs() ? 0 : 1;
                Dimension eachSize = each.getPreferredSize();
                if (data.eachX + eachSize.width < data.toFitWidth + tabsStart) {
                    each.setBounds(data.eachX, data.eachY, eachSize.width, bounds.height - data.eachY);
                    data.eachX += eachSize.width;
                    ++data.eachX;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds.width - data.eachX - data.moreRectWidth;
                    each.setBounds(data.eachX, data.eachY, width, bounds.height - data.eachY);
                    data.eachX += width;
                    ++data.eachX;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data.toDrop.size() > 0) {
            data.moreRect = new Rectangle(data.eachX + 6, 0, this.myMoreIcon.getIconWidth(), bounds.height);
            int selectedIndex = manager.getIndexOfContent(manager.getSelectedContent());
            if (selectedIndex == 0) {
                this.myMoreIcon.setPaintedIcons(false, true);
            } else if (selectedIndex == manager.getContentCount() - 1) {
                this.myMoreIcon.setPaintedIcons(true, false);
            } else {
                this.myMoreIcon.setPaintedIcons(true, true);
            }
        } else {
            data.moreRect = null;
        }
        this.myLastLayout = data;
    }

    void dropTab(LayoutData data, ContentTabLabel toDropLabel) {
        data.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data.toDrop.add(toDropLabel);
        if (data.toDrop.size() == 1) {
            data.toFitWidth -= data.moreRectWidth;
        }
    }

    boolean isToDrawTabs() {
        return this.myTabs.size() > 1;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig c = new GraphicsConfig(g);
        c.setAntialiasing(true);
        for (ContentTabLabel each : this.myTabs) {
            this.fillTabShape(g2d, each, this.getShapeFor(each), each.isSelected());
        }
        c.restore();
    }

    private Shape getShapeFor(ContentTabLabel label) {
        Rectangle bounds = label.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return new GeneralPath();
        }
        if (!label.isSelected()) {
            bounds.y += 3;
        }
        ++bounds.width;
        int arc = 2;
        GeneralPath path = new GeneralPath();
        path.moveTo(bounds.x, bounds.y + bounds.height);
        path.lineTo(bounds.x, bounds.y + arc);
        path.quadTo(bounds.x, bounds.y, bounds.x + arc, bounds.y);
        path.lineTo(bounds.x + bounds.width - arc, bounds.y);
        path.quadTo(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + arc);
        path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
        path.closePath();
        return path;
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        GraphicsConfig c = new GraphicsConfig(g);
        c.setAntialiasing(true);
        Graphics2D g2d = (Graphics2D)g;
        Color edges = this.myUi.myWindow.isActive() ? TAB_BORDER_ACTIVE_WINDOW : TAB_BORDER_PASSIVE_WINDOW;
        g2d.setColor(edges);
        for (int i = 0; i < this.myTabs.size(); ++i) {
            ContentTabLabel each = this.myTabs.get(i);
            Shape shape = this.getShapeFor(each);
            g2d.draw(shape);
        }
        c.restore();
        if (this.myLastLayout != null && this.myLastLayout.moreRect != null) {
            this.myMoreIcon.paintIcon((Component)this.myUi, g);
        }
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi);
        }
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        ContentTabLabel tab = new ContentTabLabel(event.getContent(), this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(event.getContent(), tab);
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected = this.myUi.myManager.getSelectedContent();
        if (selected != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        int moreRectWidth;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        ArrayList<ContentTabLabel> toDrop = new ArrayList();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui) {
            this.layoutSize = ui.getSize();
            this.contentCount = ui.myManager.getContentCount();
        }
    }

    private class MyPopupListener
    implements PopupMenuListener {
        private MyPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (TabContentLayout.this.myPopup != null) {
                TabContentLayout.this.myPopup.removePopupMenuListener(this);
            }
            TabContentLayout.this.myPopup = null;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

