/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesVisitorFactory;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;

public class JavaDependenciesVisitorFactory
extends DependenciesVisitorFactory {
    @Override
    public PsiElementVisitor createVisitor(final DependenciesBuilder.DependencyProcessor processor) {
        return new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
            }

            public void visitElement(PsiElement element) {
                PsiReference[] refs;
                super.visitElement(element);
                for (PsiReference ref : refs = element.getReferences()) {
                    PsiElement resolved = ref.resolve();
                    if (resolved == null) continue;
                    processor.process(ref.getElement(), resolved);
                }
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
            }

            public void visitDocComment(PsiDocComment comment) {
            }

            public void visitImportStatement(PsiImportStatement statement) {
                if (!DependencyValidationManager.getInstance((Project)statement.getProject()).skipImportStatements()) {
                    this.visitElement((PsiElement)statement);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass psiClass;
                PsiType returnType;
                super.visitMethodCallExpression(expression);
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod != null && (returnType = psiMethod.getReturnType()) != null && (psiClass = PsiUtil.resolveClassInType((PsiType)returnType)) != null) {
                    processor.process((PsiElement)expression, (PsiElement)psiClass);
                }
            }
        };
    }
}

