/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.ArtifactValidationUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactValidationUtilImpl
extends ArtifactValidationUtil {
    private Project myProject;
    private CachedValue<Set<Artifact>> mySelfIncludingArtifacts;

    public ArtifactValidationUtilImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Set<Artifact> getSelfIncludingArtifacts() {
        if (this.mySelfIncludingArtifacts == null) {
            this.mySelfIncludingArtifacts = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<Set<Artifact>>(){

                public CachedValueProvider.Result<Set<Artifact>> compute() {
                    return CachedValueProvider.Result.create((Object)ArtifactValidationUtilImpl.this.computeSelfIncludingArtifacts(), (Object[])new Object[]{ArtifactManager.getInstance((Project)ArtifactValidationUtilImpl.this.myProject).getModificationTracker()});
                }
            }, false);
        }
        return (Set)this.mySelfIncludingArtifacts.getValue();
    }

    private Set<Artifact> computeSelfIncludingArtifacts() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        HashSet<Artifact> result = new HashSet<Artifact>();
        final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        for (final Artifact artifact : artifactManager.getSortedArtifacts()) {
            if (ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactValidationUtilImpl$2.process must not be null");
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactValidationUtilImpl$2.process must not be null");
                    }
                    return !artifact.equals(element.findArtifact(context));
                }
            }, context, true)) continue;
            result.add(artifact);
        }
        return result;
    }
}

