/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.FilePathValidator;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.properties.ArchiveElementPropertiesPanel;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.util.Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ArchiveElementType
extends CompositePackagingElementType<ArchivePackagingElement> {
    ArchiveElementType() {
        super("archive", CompilerBundle.message((String)"element.type.name.archive", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return Icons.JAR_ICON;
    }

    @NotNull
    public ArchivePackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArchiveElementType.createEmpty must not be null");
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement();
        if (archivePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ArchiveElementType.createEmpty must not return null");
        }
        return archivePackagingElement;
    }

    public PackagingElementPropertiesPanel createElementPropertiesPanel(@NotNull ArchivePackagingElement element, @NotNull ArtifactEditorContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArchiveElementType.createElementPropertiesPanel must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ArchiveElementType.createElementPropertiesPanel must not be null");
        }
        String name = element.getArchiveFileName();
        if (name.length() >= 4 && name.charAt(name.length() - 4) == '.' && StringUtil.endsWithIgnoreCase((String)name, (String)"ar")) {
            return new ArchiveElementPropertiesPanel(element, context);
        }
        return null;
    }

    public CompositePackagingElement<?> createComposite(CompositePackagingElement<?> parent, @Nullable String baseName, @NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ArchiveElementType.createComposite must not be null");
        }
        String initialValue = PackagingElementFactoryImpl.suggestFileName(parent, baseName != null ? baseName : "archive", ".jar");
        String path = Messages.showInputDialog((Project)context.getProject(), (String)"Enter archive name: ", (String)"New Archive", null, (String)initialValue, (InputValidator)new FilePathValidator());
        if (path == null) {
            return null;
        }
        return PackagingElementFactoryImpl.createDirectoryOrArchiveWithParents(path, true);
    }
}

