/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleOutputPackagingElement
extends PackagingElement<ModuleOutputPackagingElementState> {
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "name";
    private ModulePointer myModulePointer;
    private final Project myProject;

    public ModuleOutputPackagingElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.<init> must not be null");
        }
        super((PackagingElementType)ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE);
        this.myProject = project;
    }

    public ModuleOutputPackagingElement(@NotNull Project project, @NotNull ModulePointer modulePointer) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.<init> must not be null");
        }
        if (modulePointer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.<init> must not be null");
        }
        super((PackagingElementType)ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE);
        this.myProject = project;
        this.myModulePointer = modulePointer;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.createPresentation must not be null");
        }
        return new DelegatedPackagingElementPresentation(new ModuleElementPresentation(this.myModulePointer, context));
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeAntInstructions must not be null");
        }
        if (creator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeAntInstructions must not be null");
        }
        if (generationContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeAntInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeAntInstructions must not be null");
        }
        if (this.myModulePointer != null) {
            String moduleOutput = BuildProperties.propertyRef((String)generationContext.getModuleOutputPath(this.myModulePointer.getModuleName()));
            return Collections.singletonList(creator.createDirectoryContentCopyInstruction(moduleOutput));
        }
        return Collections.emptyList();
    }

    public void computeIncrementalCompilerInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, @NotNull ArtifactType artifactType) {
        VirtualFile output;
        CompilerModuleExtension extension;
        if (creator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        Module module = this.findModule(resolvingContext);
        if (module != null && (extension = CompilerModuleExtension.getInstance((Module)module)) != null && (output = extension.getCompilerOutputPath()) != null) {
            creator.addDirectoryCopyInstructions(output, null);
        }
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.getFilesKind must not return null");
        }
        return packagingElementOutputKind;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ModuleOutputPackagingElement.isEqualTo must not be null");
        }
        return element instanceof ModuleOutputPackagingElement && this.myModulePointer != null && this.myModulePointer.equals(((ModuleOutputPackagingElement)element).myModulePointer);
    }

    public ModuleOutputPackagingElementState getState() {
        ModuleOutputPackagingElementState state = new ModuleOutputPackagingElementState();
        if (this.myModulePointer != null) {
            state.setModuleName(this.myModulePointer.getModuleName());
        }
        return state;
    }

    public void loadState(ModuleOutputPackagingElementState state) {
        String moduleName = state.getModuleName();
        this.myModulePointer = moduleName != null ? ModulePointerManager.getInstance((Project)this.myProject).create(moduleName) : null;
    }

    @NonNls
    public String toString() {
        return "module:" + this.getModuleName();
    }

    @Nullable
    public String getModuleName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : null;
    }

    @Nullable
    public Module findModule(PackagingElementResolvingContext context) {
        if (this.myModulePointer != null) {
            Module module = this.myModulePointer.getModule();
            ModulesProvider modulesProvider = context.getModulesProvider();
            if (module != null && (modulesProvider instanceof DefaultModulesProvider || ArrayUtil.contains((Object)module, (Object[])modulesProvider.getModules()))) {
                return module;
            }
            return modulesProvider.getModule(this.myModulePointer.getModuleName());
        }
        return null;
    }

    public static class ModuleOutputPackagingElementState {
        private String myModuleName;

        @Attribute(value="name")
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(String moduleName) {
            this.myModuleName = moduleName;
        }
    }
}

