/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformProjectOpenProcessor
extends ProjectOpenProcessor {
    public static PlatformProjectOpenProcessor getInstance() {
        PlatformProjectOpenProcessor projectOpenProcessor = PlatformProjectOpenProcessor.getInstanceIfItExists();
        assert (projectOpenProcessor != null);
        return projectOpenProcessor;
    }

    public static PlatformProjectOpenProcessor getInstanceIfItExists() {
        ProjectOpenProcessor[] processors;
        for (ProjectOpenProcessor processor : processors = (ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)) {
            if (!(processor instanceof PlatformProjectOpenProcessor)) continue;
            return (PlatformProjectOpenProcessor)processor;
        }
        return null;
    }

    public boolean canOpenProject(VirtualFile file) {
        return file.isDirectory() || !file.getFileType().isBinary();
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame) {
        int exitCode;
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/platform/PlatformProjectOpenProcessor.doOpenProject must not be null");
        }
        VirtualFile baseDir = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
        File projectDir = new File(baseDir.getPath(), ".idea");
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0 && ((exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)1, (Icon)Messages.getQuestionIcon())) == 1 ? !ProjectUtil.closeProject(projectToClose != null ? projectToClose : openProjects[openProjects.length - 1]) : exitCode != 0)) {
            return null;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        Ref cancelled = new Ref();
        if (projectDir.exists()) {
            try {
                project = ((ProjectManagerImpl)projectManager).loadProjectWithProgress(baseDir.getPath(), (Ref<Boolean>)cancelled);
            }
            catch (Exception e) {}
        } else {
            projectDir.mkdirs();
        }
        if (project == null && cancelled.isNull()) {
            project = projectManager.newProject(projectDir.getParentFile().getName(), projectDir.getParent(), true, false);
        }
        if (project == null) {
            return null;
        }
        ProjectBaseDirectory.getInstance(project).setBaseDir(baseDir);
        for (DirectoryProjectConfigurator configurator : (DirectoryProjectConfigurator[])Extensions.getExtensions(DirectoryProjectConfigurator.EP_NAME)) {
            configurator.configureProject(project, baseDir);
        }
        PlatformProjectOpenProcessor.openFileFromCommandLine(project, virtualFile);
        projectManager.openProject(project);
        return project;
    }

    private static void openFileFromCommandLine(final Project project, final VirtualFile virtualFile) {
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!virtualFile.isDirectory()) {
                                    FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public String getName() {
        return "text editor";
    }
}

