/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private final Map<ASTNode, TreeChange> myChangedElements = new THashMap();
    private final List<ASTNode> myChangedInOrder = new ArrayList<ASTNode>();
    private final List<Set<ASTNode>> myOfEqualDepth = new ArrayList<Set<ASTNode>>(10);
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(PomModelAspect aspect, FileElement treeElement) {
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    public FileElement getRootElement() {
        return this.myFileElement;
    }

    public TreeElement[] getChangedElements() {
        TreeElement[] ret = new TreeElement[this.myChangedElements.size()];
        Iterator<ASTNode> iterator = this.myChangedInOrder.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            ret[index++] = (TreeElement)iterator.next();
        }
        return ret;
    }

    public TreeChange getChangesByElement(ASTNode element) {
        return this.myChangedElements.get(element);
    }

    public void addElementaryChange(ASTNode element, ChangeInfo change) {
        ASTNode parent = element.getTreeParent();
        if (parent == null) {
            return;
        }
        ASTNode prevParent = element;
        int depth = 0;
        for (ASTNode currentParent = parent; currentParent != null; currentParent = currentParent.getTreeParent()) {
            if (this.myChangedElements.containsKey(currentParent)) {
                boolean currentParentHasChange;
                TreeChange changesByElement = this.getChangesByElement(currentParent);
                boolean bl = currentParentHasChange = changesByElement.getChangeByChild(prevParent) != null;
                if (currentParentHasChange && prevParent != element) {
                    return;
                }
                if (prevParent != element) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    if (change.getChangeType() != 1) {
                        newChange.processElementaryChange(change, element);
                    }
                    change = newChange;
                }
                this.processElementaryChange(currentParent, prevParent, change, -1);
                return;
            }
            ++depth;
            prevParent = currentParent;
        }
        this.compactChanges(parent, depth - 1);
        this.processElementaryChange(parent, element, change, depth - 1);
    }

    private static int getDepth(ASTNode element) {
        int depth = 0;
        while ((element = element.getTreeParent()) != null) {
            ++depth;
        }
        return depth;
    }

    public void clear() {
        this.myChangedElements.clear();
        this.myOfEqualDepth.clear();
    }

    private void processElementaryChange(ASTNode parent, ASTNode element, ChangeInfo change, int depth) {
        TreeChange treeChange = this.myChangedElements.get(parent);
        if (treeChange == null) {
            treeChange = new TreeChangeImpl(parent);
            this.myChangedElements.put(parent, treeChange);
            this.insertAtList(parent);
            int index = depth >= 0 ? depth : TreeChangeEventImpl.getDepth(parent);
            this.addToEqualsDepthList(index, parent);
        }
        treeChange.addChange(element, change);
        if (change.getChangeType() == 1) {
            element.putUserData(CharTable.CHAR_TABLE_KEY, (Object)this.myFileElement.getCharTable());
        }
        if (treeChange.isEmpty()) {
            this.removeAssociatedChanges(parent, depth);
        }
    }

    private void addToEqualsDepthList(int depth, ASTNode parent) {
        Set<ASTNode> treeElements;
        Set<ASTNode> set = treeElements = depth < this.myOfEqualDepth.size() ? this.myOfEqualDepth.get(depth) : null;
        if (treeElements == null) {
            treeElements = new HashSet<ASTNode>();
            while (depth > this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.add(new HashSet());
            }
            this.myOfEqualDepth.add(depth, treeElements);
        }
        treeElements.add(parent);
    }

    private void compactChanges(ASTNode parent, int depth) {
        int currentDepth = this.myOfEqualDepth.size();
        while (--currentDepth > depth) {
            Set<ASTNode> treeElements = this.myOfEqualDepth.get(currentDepth);
            if (treeElements == null) continue;
            Iterator<ASTNode> iterator = treeElements.iterator();
            while (iterator.hasNext()) {
                TreeElement treeElement;
                boolean isUnderCompacted = false;
                for (TreeElement currentParent = treeElement = (TreeElement)iterator.next(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                    if (currentParent != parent) continue;
                    isUnderCompacted = true;
                    break;
                }
                if (!isUnderCompacted) continue;
                ChangeInfoImpl compactedChange = ChangeInfoImpl.create((short)3, treeElement);
                compactedChange.compactChange(this.getChangesByElement(treeElement));
                iterator.remove();
                this.removeAssociatedChanges(treeElement, currentDepth);
                CompositeElement treeParent = treeElement.getTreeParent();
                TreeChange changesByElement = this.getChangesByElement(treeParent);
                if (changesByElement != null) {
                    ChangeInfoImpl changeByChild = (ChangeInfoImpl)changesByElement.getChangeByChild((ASTNode)treeElement);
                    if (changeByChild != null) {
                        changeByChild.setOldLength(compactedChange.getOldLength());
                        continue;
                    }
                    changesByElement.addChange((ASTNode)treeElement, (ChangeInfo)compactedChange);
                    continue;
                }
                this.processElementaryChange(treeParent, treeElement, compactedChange, currentDepth - 1);
            }
        }
    }

    private void removeAssociatedChanges(ASTNode treeElement, int depth) {
        if (this.myChangedElements.remove(treeElement) != null) {
            this.myChangedInOrder.remove(treeElement);
            if (depth < 0) {
                depth = TreeChangeEventImpl.getDepth(treeElement);
            }
            if (depth < this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.get(depth < 0 ? TreeChangeEventImpl.getDepth(treeElement) : depth).remove(treeElement);
            }
        }
    }

    private void insertAtList(ASTNode node) {
        int[] nodeRoute = TreeChangeEventImpl.getRoute(node);
        int index = 0;
        while (index < this.myChangedInOrder.size()) {
            ASTNode current;
            int[] route;
            if (TreeChangeEventImpl.compareRouts(nodeRoute, route = TreeChangeEventImpl.getRoute(current = this.myChangedInOrder.get(index++))) >= 0) continue;
            this.myChangedInOrder.add(index, node);
            return;
        }
        this.myChangedInOrder.add(node);
    }

    private static int[] getRoute(ASTNode node) {
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>(20);
        while (node != null) {
            parents.add(node);
            node = node.getTreeParent();
        }
        int[] root = new int[parents.size() - 1];
        for (int i = 0; i < root.length; ++i) {
            ASTNode parent = (ASTNode)parents.get(root.length - i - 1);
            int rootIndex = 0;
            ASTNode current = parent.getTreeParent().getFirstChildNode();
            while (current != parent) {
                current = current.getTreeNext();
                ++rootIndex;
            }
            root[i] = rootIndex;
        }
        return root;
    }

    private static int compareRouts(int[] root1, int[] root2) {
        int depth = Math.min(root1.length, root2.length);
        for (int i = 0; i < depth; ++i) {
            if (root1[i] == root2[i]) continue;
            if (root1[i] > root2[i]) {
                return 1;
            }
            if (root2[i] <= root1[i]) continue;
            return -1;
        }
        if (root1.length == root2.length) {
            return 0;
        }
        if (root1.length < root2.length) {
            return 1;
        }
        return -1;
    }

    public PomModelAspect getAspect() {
        return this.myAspect;
    }

    public void merge(PomChangeSet blocked) {
        ASTNode changed;
        if (!(blocked instanceof TreeChangeEventImpl)) {
            return;
        }
        TreeChangeEventImpl blockedTreeChange = (TreeChangeEventImpl)blocked;
        HashMap<ASTNode, TreeChange> changedElements = new HashMap<ASTNode, TreeChange>(blockedTreeChange.myChangedElements);
        Iterator iterator = changedElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ASTNode changed2 = (ASTNode)entry.getKey();
            TreeChange treeChange = this.myChangedElements.get(changed2);
            if (treeChange == null) continue;
            iterator.remove();
            treeChange.add((TreeChange)entry.getValue());
        }
        int depth = 0;
        Iterator iterator2 = changedElements.entrySet().iterator();
        block1: while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            changed = (ASTNode)entry.getKey();
            TreeElement prevParent = (TreeElement)changed;
            for (CompositeElement currentParent = (CompositeElement)changed.getTreeParent(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                if (this.myChangedElements.containsKey(currentParent)) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    int newLength = ((TreeElement)changed).getNotCachedLength();
                    int oldLength = ((TreeChange)entry.getValue()).getOldLength();
                    newChange.setOldLength(prevParent.getNotCachedLength() - newLength + oldLength);
                    this.processElementaryChange(currentParent, prevParent, newChange, -1);
                    iterator2.remove();
                    continue block1;
                }
                ++depth;
                prevParent = currentParent;
            }
        }
        for (Map.Entry entry : changedElements.entrySet()) {
            changed = (ASTNode)entry.getKey();
            this.myChangedElements.put(changed, (TreeChange)entry.getValue());
            this.insertAtList(changed);
            this.addToEqualsDepthList(depth, changed);
            this.compactChanges(changed, depth);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<ASTNode, TreeChange> entry : this.myChangedElements.entrySet()) {
            buffer.append(entry.getKey().getElementType().toString());
            buffer.append(": ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

