/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

abstract class InspectionsConfigTreeRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    InspectionsConfigTreeRenderer() {
    }

    protected abstract String getFilter();

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)value);
        Object object = node.getUserObject();
        Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
        this.setBackground(background);
        Color foreground = selected ? UIUtil.getTreeSelectionForeground() : (node.isProperSetting ? Color.BLUE : UIUtil.getTreeTextForeground());
        String text = null;
        int style = 0;
        String hint = null;
        if (object instanceof String) {
            text = (String)object;
            style = 1;
        } else {
            Descriptor descriptor = node.getDesriptor();
            String scopeName = node.getScopeName();
            if (scopeName != null) {
                if (node.isByDefault()) {
                    text = "Everywhere else";
                } else {
                    text = "In scope '" + scopeName + "'";
                    if (node.getScope() == null) {
                        foreground = Color.RED;
                    }
                }
            } else {
                text = descriptor.getText();
            }
            hint = InspectionsConfigTreeRenderer.getHint(descriptor);
        }
        if (text != null) {
            SearchUtil.appendFragments(this.getFilter(), text, style, foreground, background, this.getTextRenderer());
        }
        if (hint != null) {
            this.getTextRenderer().append(" " + hint, selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        this.setForeground(foreground);
    }

    @Nullable
    private static String getHint(Descriptor descriptor) {
        if (descriptor.getTool() == null) {
            return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node", (Object[])new Object[0]);
        }
        if (descriptor.getTool() instanceof LocalInspectionToolWrapper) {
            return null;
        }
        return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node1", (Object[])new Object[0]);
    }
}

