/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionToolsConfigurable;

public class ProjectInspectionToolsConfigurable
extends InspectionToolsConfigurable {
    public static ProjectInspectionToolsConfigurable getInstance(Project project) {
        return (ProjectInspectionToolsConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, ProjectInspectionToolsConfigurable.class);
    }

    public ProjectInspectionToolsConfigurable(InspectionProfileManager profileManager, InspectionProjectProfileManager projectProfileManager) {
        super(projectProfileManager, profileManager);
    }

    @Override
    protected InspectionProfileImpl getCurrentProfile() {
        return (InspectionProfileImpl)this.myProjectProfileManager.getProjectProfileImpl();
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        if (this.getSelectedPanel().isProfileShared()) {
            this.myProjectProfileManager.setProjectProfile(this.getSelectedObject().getName());
        } else {
            this.myProfileManager.setRootProfile(this.getSelectedObject().getName());
            this.myProjectProfileManager.setProjectProfile(null);
        }
    }

    @Override
    public boolean isModified() {
        if (!Comparing.strEqual((String)this.getCurrentProfile().getName(), (String)this.getSelectedObject().getName())) {
            return true;
        }
        return super.isModified();
    }
}

