/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PositionElementFilter;

public class BeforeElementFilter
extends PositionElementFilter {
    public BeforeElementFilter(ElementFilter filter) {
        this.setFilter(filter);
    }

    public BeforeElementFilter() {
    }

    public boolean isAcceptable(Object element, PsiElement scope) {
        if (!(element instanceof PsiElement)) {
            return false;
        }
        PsiElement ownerChild = BeforeElementFilter.getOwnerChild(scope, (PsiElement)element);
        if (ownerChild == null) {
            return false;
        }
        for (PsiElement currentChild = ownerChild.getNextSibling(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!this.getFilter().isAcceptable((Object)currentChild, scope)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "before(" + this.getFilter().toString() + ")";
    }
}

