/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.ExpressionParsing;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsParsingUtil");

    public static PsiExpression createExpressionFromText(String exprText, PsiManager manager, ClsElementImpl parent) {
        PsiJavaFile dummyJavaFile = ((PsiElementFactoryImpl)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory()).getDummyJavaFile();
        FileElement holderElement = DummyHolderFactory.createHolder(manager, (PsiElement)dummyJavaFile).getTreeElement();
        CompositeElement _expr = ExpressionParsing.parseExpressionText(manager, exprText, 0, exprText.length(), holderElement.getCharTable());
        if (_expr == null) {
            LOG.error("Could not parse expression:'" + exprText + "'");
            return null;
        }
        holderElement.rawAddChildren(_expr);
        PsiExpression expr = (PsiExpression)_expr.getPsi();
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)expr;
            return new ClsLiteralExpressionImpl(parent, exprText, literal.getType(), literal.getValue());
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiLiteralExpression operand = (PsiLiteralExpression)((PsiPrefixExpression)expr).getOperand();
            if (operand != null) {
                ClsLiteralExpressionImpl literalExpression = new ClsLiteralExpressionImpl(null, operand.getText(), operand.getType(), operand.getValue());
                ClsPrefixExpressionImpl prefixExpression = new ClsPrefixExpressionImpl(parent, (PsiExpression)literalExpression);
                literalExpression.setParent(prefixExpression);
                return prefixExpression;
            }
        } else {
            if (expr instanceof PsiReferenceExpression) {
                PsiReferenceExpression patternExpr = (PsiReferenceExpression)expr;
                return new ClsReferenceExpressionImpl(parent, patternExpr);
            }
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)manager.getProject()).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value != null) {
                return new ClsLiteralExpressionImpl(parent, exprText, expr.getType(), value);
            }
        }
        LOG.error((Object)expr);
        return null;
    }
}

