/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    public JavaMethodElementType(@NonNls String name) {
        super(name);
    }

    public PsiMethod createPsi(PsiMethodStub stub) {
        if (this.isCompiled(stub)) {
            return new ClsMethodImpl(stub);
        }
        return stub.isAnnotationMethod() ? new PsiAnnotationMethodImpl(stub) : new PsiMethodImpl(stub);
    }

    @Override
    public PsiMethod createPsi(ASTNode node) {
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    public PsiMethodStub createStub(PsiMethod psi, StubElement parentStub) {
        PsiAnnotationMemberValue defaultValue;
        byte flags = PsiMethodStubImpl.packFlags(psi.isConstructor(), psi instanceof PsiAnnotationMethod, psi.isVarArgs(), RecordUtil.isDeprecatedByDocComment((PsiElement)psi), RecordUtil.isDeprecatedByAnnotation((PsiElement)psi));
        String defValueText = null;
        if (psi instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)psi).getDefaultValue()) != null) {
            defValueText = defaultValue.getText();
        }
        return new PsiMethodStubImpl(parentStub, StringRef.fromString((String)psi.getName()), TypeInfo.create(psi.getReturnTypeNoResolve(), psi.getReturnTypeElement()), flags, StringRef.fromString((String)defValueText));
    }

    public void serialize(PsiMethodStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText(false));
        dataStream.writeByte((int)((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    public PsiMethodStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream, parentStub);
        byte flags = dataStream.readByte();
        StringRef defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readName() : null;
        return new PsiMethodStubImpl(parentStub, name, type, flags, defaultMethodValue);
    }

    public void indexStub(PsiMethodStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaMethodNameIndex.KEY, (Object)name);
        }
    }
}

