/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiParameterStubImpl
extends StubBase<PsiParameter>
implements PsiParameterStub {
    private StringRef myName;
    private final TypeInfo myType;
    private final boolean myIsEllipsis;

    public PsiParameterStubImpl(StubElement parent, String name, @NotNull TypeInfo type, boolean isEllipsis) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl.<init> must not be null");
        }
        this(parent, StringRef.fromString((String)name), type, isEllipsis);
    }

    public PsiParameterStubImpl(StubElement parent, StringRef name, @NotNull TypeInfo type, boolean isEllipsis) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl.<init> must not be null");
        }
        super(parent, (IStubElementType)JavaStubElementTypes.PARAMETER);
        this.myName = name;
        this.myType = type;
        this.myIsEllipsis = isEllipsis;
    }

    @Override
    public boolean isParameterTypeEllipsis() {
        return this.myIsEllipsis;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo;
        if (!doResolve) {
            typeInfo = this.myType;
            if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl.getType must not return null");
            return typeInfo;
        }
        typeInfo = PsiFieldStubImpl.addApplicableTypeAnnotationsFromChildModifierList(this, this.myType);
        if (typeInfo != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl.getType must not return null");
    }

    @Override
    public PsiModifierListStub getModList() {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiModifierListStub)) continue;
            return (PsiModifierListStub)child;
        }
        return null;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiParameterStub[").append(this.myName).append(':').append(TypeInfo.createTypeText(this.getType(true))).append(']');
        return builder.toString();
    }

    public void setName(String name) {
        this.myName = StringRef.fromString((String)name);
    }

    public boolean isAutoGeneratedName() {
        List children = this.getParentStub().getChildrenStubs();
        int paramIndex = 0;
        for (Object o : children) {
            if (!(o instanceof PsiParameterStub)) continue;
            ++paramIndex;
            if (o != this) continue;
            break;
        }
        return ("p" + paramIndex).equals(this.getName());
    }
}

