/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.util.CharTable;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;

public class CharTableImpl
implements CharTable {
    private static final int INTERN_THRESHOLD = 40;
    private static final CharSequenceHashingStrategy HASHER = new CharSequenceHashingStrategy();
    private static final MyTHashSet staticEntries = new MyStaticTHashSet();
    private final MyTHashSet entries = new MyTHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence intern(CharSequence text) {
        if (text.length() > 40) {
            return CharTableImpl.createSequence(text);
        }
        int idx = staticEntries.index(text);
        if (idx >= 0) {
            return staticEntries.get(idx);
        }
        CharTableImpl charTableImpl = this;
        synchronized (charTableImpl) {
            idx = this.entries.index(text);
            if (idx >= 0) {
                return this.entries.get(idx);
            }
            CharSequence entry = CharTableImpl.createSequence(text);
            boolean added = this.entries.add(entry);
            assert (added);
            return entry;
        }
    }

    public CharSequence intern(CharSequence baseText, int startOffset, int endOffset) {
        if (endOffset - startOffset == baseText.length()) {
            return ((Object)baseText).toString();
        }
        return this.intern(baseText.subSequence(startOffset, endOffset));
    }

    private static CharSequence createSequence(CharSequence text) {
        char[] buf = new char[text.length()];
        CharArrayUtil.getChars((CharSequence)text, (char[])buf, (int)0);
        return new CharArrayCharSequence(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(String text) {
        MyTHashSet myTHashSet = staticEntries;
        synchronized (myTHashSet) {
            staticEntries.add(text);
        }
    }

    private static class MyStaticTHashSet
    extends MyTHashSet {
        private MyStaticTHashSet() {
            this.add("==");
            this.add("!=");
            this.add("||");
            this.add("++");
            this.add("--");
            this.add("<");
            this.add("<=");
            this.add("<<=");
            this.add("<<");
            this.add(">");
            this.add("&");
            this.add("&&");
            this.add("+=");
            this.add("-=");
            this.add("*=");
            this.add("/=");
            this.add("&=");
            this.add("|=");
            this.add("^=");
            this.add("%=");
            this.add("(");
            this.add(")");
            this.add("{");
            this.add("}");
            this.add("[");
            this.add("]");
            this.add(";");
            this.add(",");
            this.add("...");
            this.add(".");
            this.add("=");
            this.add("!");
            this.add("~");
            this.add("?");
            this.add(":");
            this.add("+");
            this.add("-");
            this.add("*");
            this.add("/");
            this.add("|");
            this.add("^");
            this.add("%");
            this.add("@");
            this.add(" ");
            this.add("  ");
            this.add("   ");
            this.add("    ");
            this.add("     ");
            this.add("      ");
            this.add("       ");
            this.add("        ");
            this.add("         ");
            this.add("          ");
            this.add("           ");
            this.add("            ");
            this.add("             ");
            this.add("              ");
            this.add("               ");
            this.add("\n");
            this.add("\n  ");
            this.add("\n    ");
            this.add("\n      ");
            this.add("\n        ");
            this.add("\n          ");
            this.add("\n            ");
            this.add("\n              ");
            this.add("\n                ");
            this.add("<");
            this.add(">");
            this.add("</");
            this.add("/>");
            this.add("\"");
            this.add("'");
            this.add("<![CDATA[");
            this.add("]]>");
            this.add("<!--");
            this.add("-->");
            this.add("<!DOCTYPE");
            this.add("SYSTEM");
            this.add("PUBLIC");
            this.add("<?");
            this.add("?>");
            this.add("<%");
            this.add("%>");
            this.add("<%=");
            this.add("<%@");
            this.add("${");
            this.add("");
        }
    }

    private static class MyTHashSet
    extends THashSet<CharSequence> {
        private MyTHashSet() {
            super(10, 0.9f, (TObjectHashingStrategy)HASHER);
        }

        public int index(CharSequence obj) {
            return super.index((Object)obj);
        }

        public CharSequence get(int index) {
            return (CharSequence)this._set[index];
        }
    }
}

