/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.caches.FileContent;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPsiFileImpl
extends PsiElementBase
implements PsiFileEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.LightPsiFileImpl");
    private PsiFile myOriginalFile = null;
    private boolean myExplicitlySetAsValid = false;
    private final FileViewProvider myViewProvider;
    private final PsiManagerImpl myManager;
    private final Language myLanguage;

    public LightPsiFileImpl(FileViewProvider provider, Language language) {
        this.myViewProvider = provider;
        this.myManager = (PsiManagerImpl)provider.getManager();
        this.myLanguage = language;
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public boolean isValid() {
        if (!this.getViewProvider().isPhysical() || this.myExplicitlySetAsValid) {
            return true;
        }
        return this.getViewProvider().getVirtualFile().isValid();
    }

    public void setIsValidExplicitly(boolean b) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExplicitlySetAsValid = b;
    }

    public String getText() {
        return ((Object)this.getViewProvider().getContents()).toString();
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    public void subtreeChanged() {
        this.clearCaches();
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    public abstract void clearCaches();

    protected LightPsiFileImpl clone() {
        FileViewProvider provider = this.getViewProvider().clone();
        LightPsiFileImpl clone = (LightPsiFileImpl)provider.getPsi(this.getLanguage());
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getViewProvider().isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.setName must not be null");
        }
        this.checkSetName(name);
        this.subtreeChanged();
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    public PsiFile getContainingFile() {
        return this;
    }

    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        LightPsiFileImpl lightPsiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (lightPsiFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getOriginalFile must not return null");
        }
        return lightPsiFileImpl;
    }

    public void setOriginalFile(PsiFile originalFile) {
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getPsiRoots must not return null");
        }
        return psiFileArray;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getLanguage must not return null");
        }
        return language;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.acceptChildren must not be null");
        }
        PsiElement child = this.getFirstChild();
        while (child != null) {
            PsiElement nextSibling = child.getNextSibling();
            child.accept(visitor);
            child = nextSibling;
        }
    }

    public final synchronized PsiElement copy() {
        return this.clone();
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public synchronized PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.processDeclarations must not be null");
        }
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ((PsiManagerEx)this.getManager()).getFileManager().getUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public FileStatus getFileStatus() {
        if (!this.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = this.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile != null ? FileStatusManager.getInstance((Project)this.getProject()).getStatus(vFile) : FileStatus.NOT_CHANGED;
    }

    @Override
    public void navigate(boolean requestFocus) {
        EditSourceUtil.getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public synchronized PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public synchronized PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequenceStrict((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/LightPsiFileImpl.textToCharArray must not return null");
        }
        return cArray;
    }

    @Override
    public boolean isContentsLoaded() {
        return true;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public PsiFile cacheCopy(FileContent content) {
        return this;
    }

    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @NotNull
    public abstract PsiElement[] getChildren();

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        return children.length == 0 ? null : children[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        return children.length == 0 ? null : children[children.length - 1];
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return this.getViewProvider().getContents().length();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.textMatches must not be null");
        }
        return this.textMatches(element.getText());
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.textMatches must not be null");
        }
        return text.equals(this.getViewProvider().getContents());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.add must not be null");
        }
        throw new IncorrectOperationException("Not implemented");
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException("Not implemented");
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.addRangeBefore must not be null");
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/LightPsiFileImpl.replace must not be null");
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    public ASTNode getNode() {
        return null;
    }

    public abstract LightPsiFileImpl copyLight(FileViewProvider var1);

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }
}

