/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    public PsiElement getElement() {
        return this.myStatement;
    }

    public TextRange getRangeInElement() {
        int parent = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(parent, this.myIdentifier.getTextLength() + parent);
    }

    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        if (label == null) {
            return null;
        }
        for (PsiStatement context = this.myStatement; context != null; context = context.getContext()) {
            PsiLabeledStatement statement;
            if (!(context instanceof PsiLabeledStatement) || !label.equals((statement = (PsiLabeledStatement)context).getName())) continue;
            return statement;
        }
        return null;
    }

    public String getCanonicalText() {
        return this.getElement().getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName((PsiElement)this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiLabelReference.bindToElement must not be null");
        }
        if (element instanceof PsiLabeledStatement) {
            this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName((PsiElement)this.myIdentifier, ((PsiLabeledStatement)element).getName());
            return this.myIdentifier;
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<PsiStatement> result = new ArrayList<PsiStatement>();
        for (PsiStatement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement)) continue;
            result.add(context);
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiLabelReference.getVariants must not return null");
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }
}

