/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiDocParamRef
extends CompositePsiElement
implements PsiDocTagValue {
    private volatile PsiReference myCachedReference;

    public PsiDocParamRef() {
        super(Constants.DOC_PARAMETER_REF);
    }

    @Override
    public void clearCaches() {
        this.myCachedReference = null;
        super.clearCaches();
    }

    @Override
    public PsiReference getReference() {
        PsiReference cachedReference = this.myCachedReference;
        if (cachedReference != null) {
            return cachedReference;
        }
        PsiDocComment comment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
        if (comment == null) {
            return null;
        }
        final PsiDocCommentOwner owner = comment.getOwner();
        if (!(owner instanceof PsiMethod) && !(owner instanceof PsiClass)) {
            return null;
        }
        final ASTNode valueToken = this.findChildByType(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        if (valueToken == null) {
            return null;
        }
        this.myCachedReference = cachedReference = new PsiReference(){

            public PsiElement resolve() {
                block3: {
                    PsiParameter[] parameters;
                    String name;
                    block2: {
                        PsiTypeParameter[] typeParameters;
                        name = valueToken.getText();
                        PsiElement firstChild = PsiDocParamRef.this.getFirstChild();
                        if (!(firstChild instanceof PsiDocToken) || !((PsiDocToken)firstChild).getTokenType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) break block2;
                        for (PsiTypeParameter typeParameter : typeParameters = ((PsiTypeParameterListOwner)owner).getTypeParameters()) {
                            if (!typeParameter.getName().equals(name)) continue;
                            return typeParameter;
                        }
                        break block3;
                    }
                    if (!(owner instanceof PsiMethod)) break block3;
                    for (PsiParameter parameter : parameters = ((PsiMethod)owner).getParameterList().getParameters()) {
                        if (!parameter.getName().equals(name)) continue;
                        return parameter;
                    }
                }
                return null;
            }

            public String getCanonicalText() {
                return valueToken.getText();
            }

            public PsiElement handleElementRename(String newElementName) {
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(PsiDocParamRef.this.getNode());
                LeafElement newElement = Factory.createSingleLeafElement(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, newElementName, charTableByTree, PsiDocParamRef.this.getManager());
                PsiDocParamRef.this.replaceChild(valueToken, newElement);
                return PsiDocParamRef.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.bindToElement must not be null");
                }
                if (this.isReferenceTo(element)) {
                    return PsiDocParamRef.this;
                }
                if (!(element instanceof PsiParameter)) {
                    throw new IncorrectOperationException("Unsupported operation");
                }
                return this.handleElementRename(((PsiParameter)element).getName());
            }

            public boolean isReferenceTo(PsiElement element) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                PsiNamedElement namedElement = (PsiNamedElement)element;
                if (!this.getCanonicalText().equals(namedElement.getName())) {
                    return false;
                }
                return PsiDocParamRef.this.getManager().areElementsEquivalent(this.resolve(), element);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Object[] getVariants() {
                Object[] objectArray;
                PsiElement firstChild = PsiDocParamRef.this.getFirstChild();
                if (firstChild instanceof PsiDocToken && ((PsiDocToken)firstChild).getTokenType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) {
                    objectArray = ((PsiTypeParameterListOwner)owner).getTypeParameters();
                    if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.getVariants must not return null");
                    return objectArray;
                }
                if (owner instanceof PsiMethod) {
                    objectArray = ((PsiMethod)owner).getParameterList().getParameters();
                    if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.getVariants must not return null");
                    return objectArray;
                }
                objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
                if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.getVariants must not return null");
            }

            public boolean isSoft() {
                return false;
            }

            public TextRange getRangeInElement() {
                int startOffsetInParent = valueToken.getPsi().getStartOffsetInParent();
                return new TextRange(startOffsetInParent, startOffsetInParent + valueToken.getTextLength());
            }

            public PsiElement getElement() {
                return PsiDocParamRef.this;
            }
        };
        return cachedReference;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocParamRef.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTagValue((PsiDocTagValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

