/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.StoppableLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.DeclarationParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.AbstractJspJavaLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StatementParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.StatementParsing");
    private List<StatementParsingHandler> myCustomHandlers = null;
    private static final int RBRACE_IS_ERROR = 1;
    private static final int RBRACE_IS_END = 2;
    private static final int LAST_RBRACE_IS_END = 3;

    public StatementParsing(JavaParsingContext context) {
        super(context);
    }

    public void registerCustomStatementParser(StatementParsingHandler handler) {
        if (this.myCustomHandlers == null) {
            this.myCustomHandlers = new ArrayList<StatementParsingHandler>();
        }
        this.myCustomHandlers.add(handler);
    }

    public CompositeElement parseCodeBlockText(PsiManager manager, CharSequence buffer) {
        return this.parseCodeBlockText(manager, null, buffer, 0, buffer.length(), -1);
    }

    public CompositeElement parseCodeBlockText(PsiManager manager, Lexer lexer, CharSequence buffer, int startOffset, int endOffset, int state) {
        if (lexer == null) {
            lexer = new JavaLexer(this.myContext.getLanguageLevel());
        }
        FilterLexer filterLexer = new FilterLexer(lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        if (state < 0) {
            filterLexer.start(buffer, startOffset, endOffset);
        } else {
            filterLexer.start(buffer, startOffset, endOffset, state);
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        LazyParseableElement block = ASTFactory.lazy(JavaElementType.CODE_BLOCK, null);
        dummyRoot.rawAddChildren(block);
        this.parseCodeBlockDeep(block, (Lexer)filterLexer, true);
        if (((CompositeElement)block).getFirstChildNode() == null) {
            return null;
        }
        ParseUtil.insertMissingTokens(block, lexer, startOffset, endOffset, state, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return block;
    }

    public TreeElement parseStatements(PsiManager manager, Lexer lexer, CharSequence buffer, int startOffset, int endOffset, int state) {
        if (lexer == null) {
            lexer = new JavaLexer(this.myContext.getLanguageLevel());
        }
        FilterLexer filterLexer = new FilterLexer(lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        if (state < 0) {
            filterLexer.start(buffer, startOffset, endOffset);
        } else {
            filterLexer.start(buffer, startOffset, endOffset, state);
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        this.parseStatements(dummyRoot, (Lexer)filterLexer, 1);
        ParseUtil.insertMissingTokens(dummyRoot, lexer, startOffset, endOffset, state, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return dummyRoot.getFirstChildNode();
    }

    public TreeElement parseCodeBlock(Lexer lexer, boolean deep) {
        Lexer original;
        Lexer badLexer;
        if (lexer.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        Lexer lexer2 = badLexer = lexer instanceof StoppableLexerAdapter ? ((StoppableLexerAdapter)lexer).getDelegate() : lexer;
        if (badLexer instanceof FilterLexer && (original = ((FilterLexer)badLexer).getOriginal()) instanceof AbstractJspJavaLexer) {
            deep = true;
        }
        if (!deep) {
            int end;
            int start = lexer.getTokenStart();
            lexer.advance();
            int braceCount = 1;
            while (true) {
                IElementType tokenType;
                if ((tokenType = lexer.getTokenType()) == null) {
                    end = lexer.getTokenStart();
                    break;
                }
                if (tokenType == JavaTokenType.LBRACE) {
                    ++braceCount;
                } else if (tokenType == JavaTokenType.RBRACE) {
                    --braceCount;
                }
                if (braceCount == 0) {
                    end = lexer.getTokenEnd();
                    lexer.advance();
                    break;
                }
                if (braceCount == 1 && (tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.RBRACE)) {
                    IElementType type;
                    lexer.advance();
                    LexerPosition position = lexer.getCurrentPosition();
                    SmartList list = new SmartList();
                    while (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(type = lexer.getTokenType()) || type == JavaTokenType.IDENTIFIER || ElementType.MODIFIER_BIT_SET.contains(type) || type == JavaTokenType.LT || type == JavaTokenType.GT || type == JavaTokenType.GTGT || type == JavaTokenType.GTGTGT || type == JavaTokenType.COMMA || type == JavaTokenType.DOT || type == JavaTokenType.EXTENDS_KEYWORD || type == JavaTokenType.IMPLEMENTS_KEYWORD) {
                        list.add(type);
                        lexer.advance();
                    }
                    if (lexer.getTokenType() != JavaTokenType.LPARENTH || list.size() < 2) continue;
                    IElementType last = (IElementType)list.get(list.size() - 1);
                    IElementType prevLast = (IElementType)list.get(list.size() - 2);
                    if (last != JavaTokenType.IDENTIFIER || prevLast != JavaTokenType.IDENTIFIER && !ElementType.PRIMITIVE_TYPE_BIT_SET.contains(prevLast)) continue;
                    lexer.restore(position);
                    end = lexer.getTokenStart();
                    break;
                }
                lexer.advance();
            }
            LazyParseableElement chameleon = ASTFactory.lazy(JavaElementType.CODE_BLOCK, this.myContext.getCharTable().intern(lexer.getBufferSequence(), start, end));
            if (braceCount != 0) {
                chameleon.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
            }
            return chameleon;
        }
        LazyParseableElement codeBlock = ASTFactory.lazy(JavaElementType.CODE_BLOCK, null);
        this.parseCodeBlockDeep(codeBlock, lexer, false);
        return codeBlock;
    }

    private void parseCodeBlockDeep(CompositeElement elementToAdd, Lexer lexer, boolean parseToEndOfLexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.LBRACE, (Object)lexer.getTokenType());
        elementToAdd.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        this.parseStatements(elementToAdd, lexer, parseToEndOfLexer ? 3 : 2);
        TreeElement lastChild = elementToAdd.getLastChildNode();
        if (lastChild == null || lastChild.getElementType() != JavaTokenType.RBRACE) {
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.rbrace", new Object[0]));
            elementToAdd.rawAddChildren(errorElement);
            elementToAdd.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
        }
    }

    private void parseStatements(CompositeElement elementToAdd, Lexer lexer, int rbraceMode) {
        while (lexer.getTokenType() != null) {
            TreeElement statement = this.parseStatement(lexer);
            if (statement != null) {
                elementToAdd.rawAddChildren(statement);
                continue;
            }
            IElementType tokenType = lexer.getTokenType();
            TreeElement tokenElement = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (tokenType == JavaTokenType.RBRACE && rbraceMode != 1) {
                if (rbraceMode == 2) {
                    elementToAdd.rawAddChildren(tokenElement);
                    return;
                }
                if (rbraceMode == 3) {
                    if (lexer.getTokenType() == null) {
                        elementToAdd.rawAddChildren(tokenElement);
                        return;
                    }
                } else {
                    LOG.assertTrue(false);
                }
            }
            String error = tokenType == JavaTokenType.ELSE_KEYWORD ? JavaErrorMessages.message("else.without.if", new Object[0]) : (tokenType == JavaTokenType.CATCH_KEYWORD ? JavaErrorMessages.message("catch.without.try", new Object[0]) : (tokenType == JavaTokenType.FINAL_KEYWORD ? JavaErrorMessages.message("finally.without.try", new Object[0]) : JavaErrorMessages.message("unexpected.token", new Object[0])));
            CompositeElement errorElement = Factory.createErrorElement(error);
            errorElement.rawAddChildren(tokenElement);
            elementToAdd.rawAddChildren(errorElement);
        }
    }

    @Nullable
    public TreeElement parseStatementText(CharSequence buffer) {
        JavaLexer lexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer filterLexer = new FilterLexer((Lexer)lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        filterLexer.start(buffer);
        TreeElement statement = this.parseStatement((Lexer)filterLexer);
        if (statement == null) {
            return null;
        }
        if (filterLexer.getTokenType() != null) {
            return null;
        }
        if (statement instanceof CompositeElement) {
            ParseUtil.insertMissingTokens((CompositeElement)statement, (Lexer)lexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        }
        return statement;
    }

    @Nullable
    public TreeElement parseStatement(Lexer lexer) {
        TreeElement decl;
        CompositeElement element;
        IElementType tokenType = lexer.getTokenType();
        if (this.myCustomHandlers != null) {
            for (StatementParsingHandler handler : this.myCustomHandlers) {
                StatementParser parser = handler.getParserForToken(tokenType);
                if (parser == null) continue;
                return parser.parseStatement(lexer);
            }
        }
        if (tokenType == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(lexer);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(lexer);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(lexer);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(lexer);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(lexer);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(lexer);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(lexer);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return this.parseContinueStatement(lexer);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(lexer);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(lexer);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(lexer);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(lexer);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(lexer);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(lexer);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            LazyParseableElement declaration = ASTFactory.lazy((ILazyParseableElementType)tokenType, this.myContext.tokenText(lexer));
            lexer.advance();
            return declaration;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            CompositeElement element2 = ASTFactory.composite(JavaElementType.EMPTY_STATEMENT);
            element2.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            return element2;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            LexerPosition refPos = lexer.getCurrentPosition();
            this.parseAnnotationListTo(lexer, null);
            StatementParsing.skipQualifiedName(lexer);
            IElementType suspectedLT = lexer.getTokenType();
            lexer.restore(refPos);
            LOG.assertTrue(lexer.getTokenType() == JavaTokenType.IDENTIFIER || lexer.getTokenType() == JavaTokenType.AT);
            if (suspectedLT == JavaTokenType.LT) {
                TreeElement decl2 = this.myContext.getDeclarationParsing().parseDeclaration(lexer, DeclarationParsing.Context.CODE_BLOCK_CONTEXT);
                CompositeElement declStatement = ASTFactory.composite(JavaElementType.DECLARATION_STATEMENT);
                if (decl2 != null) {
                    declStatement.rawAddChildren(decl2);
                } else {
                    CompositeElement type = this.parseType(lexer, false, false);
                    if (type != null) {
                        declStatement.rawAddChildren(type);
                    }
                    CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0]));
                    declStatement.rawAddChildren(errorElement);
                }
                return declStatement;
            }
        }
        LexerPosition pos = lexer.getCurrentPosition();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        LexerPosition pos1 = lexer.getCurrentPosition();
        if (expr != null) {
            int count = 1;
            element = null;
            while (lexer.getTokenType() == JavaTokenType.COMMA) {
                CompositeElement list = ASTFactory.composite(JavaElementType.EXPRESSION_LIST);
                element = ASTFactory.composite(JavaElementType.EXPRESSION_LIST_STATEMENT);
                element.rawAddChildren(list);
                list.rawAddChildren(expr);
                LexerPosition commaPos = lexer.getCurrentPosition();
                TreeElement comma = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                lexer.advance();
                CompositeElement expr1 = this.myContext.getExpressionParsing().parseExpression(lexer);
                if (expr1 == null) {
                    lexer.restore(commaPos);
                    break;
                }
                list.rawAddChildren(comma);
                list.rawAddChildren(expr1);
                ++count;
            }
            if (count > 1) {
                this.processClosingSemicolon(element, lexer);
                return element;
            }
            if (expr.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
                element = ASTFactory.composite(JavaElementType.EXPRESSION_STATEMENT);
                element.rawAddChildren(expr);
                this.processClosingSemicolon(element, lexer);
                return element;
            }
            lexer.restore(pos);
        }
        if ((decl = this.myContext.getDeclarationParsing().parseDeclaration(lexer, DeclarationParsing.Context.CODE_BLOCK_CONTEXT)) != null) {
            CompositeElement declStatement = ASTFactory.composite(JavaElementType.DECLARATION_STATEMENT);
            declStatement.rawAddChildren(decl);
            return declStatement;
        }
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            TreeElement identifier = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (lexer.getTokenType() == JavaTokenType.COLON) {
                CompositeElement element3 = ASTFactory.composite(JavaElementType.LABELED_STATEMENT);
                element3.rawAddChildren(identifier);
                element3.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                TreeElement statement = this.parseStatement(lexer);
                if (statement != null) {
                    element3.rawAddChildren(statement);
                }
                return element3;
            }
            lexer.restore(pos);
        }
        if (expr != null) {
            lexer.restore(pos1);
            element = ASTFactory.composite(JavaElementType.EXPRESSION_STATEMENT);
            element.rawAddChildren(expr);
            this.processClosingSemicolon(element, lexer);
            return element;
        }
        return null;
    }

    private static void skipQualifiedName(Lexer lexer) {
        LexerPosition position;
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            return;
        }
        do {
            lexer.advance();
            if (lexer.getTokenType() != JavaTokenType.DOT) {
                return;
            }
            position = lexer.getCurrentPosition();
            lexer.advance();
        } while (lexer.getTokenType() == JavaTokenType.IDENTIFIER);
        lexer.restore(position);
    }

    private CompositeElement parseIfStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.IF_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.IF_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (!this.processExpressionInParens(lexer, element)) {
            return element;
        }
        TreeElement thenStatement = this.parseStatement(lexer);
        if (thenStatement == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            return element;
        }
        element.rawAddChildren(thenStatement);
        if (lexer.getTokenType() != JavaTokenType.ELSE_KEYWORD) {
            return element;
        }
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement elseStatement = this.parseStatement(lexer);
        if (elseStatement == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            return element;
        }
        element.rawAddChildren(elseStatement);
        return element;
    }

    private CompositeElement parseWhileStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.WHILE_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.WHILE_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (!this.processExpressionInParens(lexer, element)) {
            return element;
        }
        TreeElement statement = this.parseStatement(lexer);
        if (statement == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            return element;
        }
        element.rawAddChildren(statement);
        return element;
    }

    private CompositeElement parseForStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.FOR_KEYWORD);
        TreeElement forKeyword = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        if (lexer.getTokenType() != JavaTokenType.LPARENTH) {
            CompositeElement errorForElement = ASTFactory.composite(JavaElementType.FOR_STATEMENT);
            errorForElement.rawAddChildren(forKeyword);
            errorForElement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lparen", new Object[0])));
            return errorForElement;
        }
        TreeElement lparenth = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        LexerPosition afterLParenth = lexer.getCurrentPosition();
        TreeElement parameter = this.myContext.getDeclarationParsing().parseParameter(lexer, false);
        if (parameter == null || parameter.getElementType() != JavaElementType.PARAMETER || lexer.getTokenType() != JavaTokenType.COLON) {
            lexer.restore(afterLParenth);
            return this.parseForLoopFromInitialization(forKeyword, lparenth, lexer);
        }
        return this.parseForEachFromColon(forKeyword, lparenth, parameter, lexer);
    }

    private CompositeElement parseForEachFromColon(TreeElement forKeyword, TreeElement lparenth, TreeElement parameter, Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.COLON);
        CompositeElement element = ASTFactory.composite(JavaElementType.FOREACH_STATEMENT);
        element.rawAddChildren(forKeyword);
        element.rawAddChildren(lparenth);
        element.rawAddChildren(parameter);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expr != null) {
            element.rawAddChildren(expr);
        } else {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
        }
        if (lexer.getTokenType() == JavaTokenType.RPARENTH) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            TreeElement body = this.parseStatement(lexer);
            if (body != null) {
                element.rawAddChildren(body);
            } else {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            }
        } else {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
        }
        return element;
    }

    private CompositeElement parseForLoopFromInitialization(TreeElement forKeyword, TreeElement lparenth, Lexer lexer) {
        CompositeElement element = ASTFactory.composite(JavaElementType.FOR_STATEMENT);
        element.rawAddChildren(forKeyword);
        element.rawAddChildren(lparenth);
        TreeElement init = this.parseStatement(lexer);
        if (init == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                return element;
            }
        } else {
            element.rawAddChildren(init);
            CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
            if (expr != null) {
                element.rawAddChildren(expr);
            }
            if (lexer.getTokenType() != JavaTokenType.SEMICOLON) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
                if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                    return element;
                }
            } else {
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                this.parseExpressionOrExpressionList(lexer, element);
                if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
                    return element;
                }
            }
        }
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement statement = this.parseStatement(lexer);
        if (statement == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            return element;
        }
        element.rawAddChildren(statement);
        return element;
    }

    private void parseExpressionOrExpressionList(Lexer lexer, CompositeElement element) {
        CompositeElement expression = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expression != null) {
            CompositeElement expressionStatement;
            if (lexer.getTokenType() != JavaTokenType.COMMA) {
                expressionStatement = ASTFactory.composite(JavaElementType.EXPRESSION_STATEMENT);
                expressionStatement.rawAddChildren(expression);
            } else {
                expressionStatement = ASTFactory.composite(JavaElementType.EXPRESSION_LIST_STATEMENT);
                CompositeElement expressionList = ASTFactory.composite(JavaElementType.EXPRESSION_LIST);
                expressionList.rawAddChildren(expression);
                do {
                    expressionList.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    CompositeElement nextExpression = this.myContext.getExpressionParsing().parseExpression(lexer);
                    if (nextExpression != null) {
                        expressionList.rawAddChildren(nextExpression);
                        continue;
                    }
                    expressionList.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                } while (lexer.getTokenType() == JavaTokenType.COMMA);
                expressionStatement.rawAddChildren(expressionList);
            }
            element.rawAddChildren(expressionStatement);
        }
    }

    private CompositeElement parseDoWhileStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.DO_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.DO_WHILE_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement statement = this.parseStatement(lexer);
        if (statement == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.statement", new Object[0])));
            return element;
        }
        element.rawAddChildren(statement);
        if (lexer.getTokenType() != JavaTokenType.WHILE_KEYWORD) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.while", new Object[0])));
            return element;
        }
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (!this.processExpressionInParens(lexer, element)) {
            return element;
        }
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseSwitchStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.SWITCH_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.SWITCH_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (!this.processExpressionInParens(lexer, element)) {
            return element;
        }
        TreeElement codeBlock = this.parseCodeBlock(lexer, false);
        if (codeBlock == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0])));
            return element;
        }
        element.rawAddChildren(codeBlock);
        return element;
    }

    @Nullable
    private CompositeElement parseSwitchLabelStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.CASE_KEYWORD || lexer.getTokenType() == JavaTokenType.DEFAULT_KEYWORD);
        IElementType tokenType = lexer.getTokenType();
        LexerPosition pos = lexer.getCurrentPosition();
        CompositeElement element = ASTFactory.composite(JavaElementType.SWITCH_LABEL_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (tokenType == JavaTokenType.CASE_KEYWORD) {
            CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
            if (expr == null) {
                lexer.restore(pos);
                return null;
            }
            element.rawAddChildren(expr);
        }
        if (lexer.getTokenType() == JavaTokenType.COLON) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.colon", new Object[0])));
        }
        return element;
    }

    private CompositeElement parseBreakStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.BREAK_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.BREAK_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseContinueStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.CONTINUE_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.CONTINUE_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        }
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseReturnStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.RETURN_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.RETURN_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expr != null) {
            element.rawAddChildren(expr);
        }
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseThrowStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.THROW_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.THROW_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expr == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            return element;
        }
        element.rawAddChildren(expr);
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseSynchronizedStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.SYNCHRONIZED_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.SYNCHRONIZED_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (!this.processExpressionInParens(lexer, element)) {
            return element;
        }
        TreeElement codeBlock = this.parseCodeBlock(lexer, false);
        if (codeBlock == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0])));
            return element;
        }
        element.rawAddChildren(codeBlock);
        return element;
    }

    private CompositeElement parseTryStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.TRY_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.TRY_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement codeBlock = this.parseCodeBlock(lexer, false);
        if (codeBlock == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0])));
            return element;
        }
        element.rawAddChildren(codeBlock);
        if (lexer.getTokenType() != JavaTokenType.CATCH_KEYWORD && lexer.getTokenType() != JavaTokenType.FINALLY_KEYWORD) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.catch.or.finally", new Object[0])));
            return element;
        }
        while (lexer.getTokenType() == JavaTokenType.CATCH_KEYWORD) {
            CompositeElement catchSection = this.parseCatchSection(lexer);
            element.rawAddChildren(catchSection);
            TreeElement lastChild = catchSection.getLastChildNode();
            assert (lastChild != null);
            if (lastChild.getElementType() != TokenType.ERROR_ELEMENT) continue;
            break;
        }
        if (lexer.getTokenType() == JavaTokenType.FINALLY_KEYWORD) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            codeBlock = this.parseCodeBlock(lexer, false);
            if (codeBlock == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0])));
                return element;
            }
            element.rawAddChildren(codeBlock);
        }
        return element;
    }

    private CompositeElement parseCatchSection(Lexer lexer) {
        CompositeElement catchSection = ASTFactory.composite(JavaElementType.CATCH_SECTION);
        catchSection.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (lexer.getTokenType() != JavaTokenType.LPARENTH) {
            catchSection.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lparen", new Object[0])));
            return catchSection;
        }
        catchSection.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement parm = this.myContext.getDeclarationParsing().parseParameter(lexer, false);
        if (parm == null) {
            catchSection.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.parameter", new Object[0])));
        } else {
            catchSection.rawAddChildren(parm);
        }
        if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
            catchSection.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
            return catchSection;
        }
        catchSection.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        TreeElement codeBlock = this.parseCodeBlock(lexer, false);
        if (codeBlock == null) {
            catchSection.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbrace", new Object[0])));
            return catchSection;
        }
        catchSection.rawAddChildren(codeBlock);
        return catchSection;
    }

    private CompositeElement parseAssertStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.ASSERT_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.ASSERT_STATEMENT);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expr == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.boolean.expression", new Object[0])));
            return element;
        }
        element.rawAddChildren(expr);
        if (lexer.getTokenType() == JavaTokenType.COLON) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            CompositeElement expr2 = this.myContext.getExpressionParsing().parseExpression(lexer);
            if (expr2 == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                return element;
            }
            element.rawAddChildren(expr2);
        }
        this.processClosingSemicolon(element, lexer);
        return element;
    }

    private CompositeElement parseBlockStatement(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.LBRACE);
        CompositeElement element = ASTFactory.composite(JavaElementType.BLOCK_STATEMENT);
        TreeElement codeBlock = this.parseCodeBlock(lexer, false);
        element.rawAddChildren(codeBlock);
        return element;
    }

    private boolean processExpressionInParens(Lexer lexer, CompositeElement parent) {
        if (lexer.getTokenType() != JavaTokenType.LPARENTH) {
            parent.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lparen", new Object[0])));
            return false;
        }
        parent.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        LexerPosition beforeExprPos = lexer.getCurrentPosition();
        CompositeElement expr = this.myContext.getExpressionParsing().parseExpression(lexer);
        if (expr == null || lexer.getTokenType() == JavaTokenType.SEMICOLON) {
            if (expr != null) {
                lexer.restore(beforeExprPos);
            }
            parent.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            parent.rawAddChildren(expr);
            if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                parent.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
                return false;
            }
        }
        parent.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        return true;
    }

    private void processClosingSemicolon(CompositeElement statement, Lexer lexer) {
        if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
            statement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            statement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
        }
    }

    @Nullable
    public TreeElement parseCatchSectionText(CharSequence buffer) {
        JavaLexer lexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer filterLexer = new FilterLexer((Lexer)lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        filterLexer.start(buffer);
        CompositeElement catchSection = this.parseCatchSection((Lexer)filterLexer);
        if (catchSection == null) {
            return null;
        }
        if (filterLexer.getTokenType() != null) {
            return null;
        }
        ParseUtil.insertMissingTokens(catchSection, (Lexer)lexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return catchSection;
    }

    public static interface StatementParsingHandler {
        @Nullable
        public StatementParser getParserForToken(IElementType var1);
    }

    public static interface StatementParser {
        @Nullable
        public CompositeElement parseStatement(Lexer var1);
    }
}

