/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.IgnoreExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URIReferenceProvider
extends PsiReferenceProvider {
    public static final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement parent = context.getParent();
            if (parent instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)parent;
                return attribute.isNamespaceDeclaration();
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };
    @NonNls
    private static final String HTTP = "http://";
    @NonNls
    private static final String URN = "urn:";
    @NonNls
    private static final String FILE = "file:";
    @NonNls
    private static final String CLASSPATH = "classpath:/";
    @NonNls
    private static final String NAMESPACE_ATTR_NAME = "namespace";

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getReferencesByElement must not be null");
        }
        String text = element.getText();
        String s = StringUtil.stripQuotesAroundValue((String)text);
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute) || !"xsi:schemaLocation".equals(((XmlAttribute)parent).getName())) {
            if ((URIReferenceProvider.isUrlText(s, element.getProject()) || parent instanceof XmlAttribute && (((XmlAttribute)parent).isNamespaceDeclaration() || NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()))) && !s.startsWith("urn:jsptagdir:")) {
                boolean namespaceSoftRef;
                boolean bl = namespaceSoftRef = parent instanceof XmlAttribute && NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && ((XmlAttribute)parent).getParent().getAttributeValue("schemaLocation") != null;
                if (!namespaceSoftRef && parent instanceof XmlAttribute && ((XmlAttribute)parent).isNamespaceDeclaration()) {
                    namespaceSoftRef = parent.getContainingFile().getContext() != null;
                }
                if ((psiReferenceArray = URIReferenceProvider.getUrlReference(element, namespaceSoftRef)) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            } else {
                psiReferenceArray = new FileReferenceSet(s = s.substring(URIReferenceProvider.getPrefixLength(s)), element, text.indexOf(s), this, true).getAllReferences();
                if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>(2);
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreElements()) {
            String namespace = tokenizer.nextToken();
            int offset = text.indexOf(namespace);
            URLReference urlReference = new URLReference(element, new TextRange(offset, offset + namespace.length()), true);
            refs.add(urlReference);
            if (!tokenizer.hasMoreElements()) break;
            String url = tokenizer.nextToken();
            offset = text.indexOf(url);
            if (URIReferenceProvider.isUrlText(url, element.getProject())) {
                refs.add(new DependentNSReference(element, new TextRange(offset, offset + url.length()), urlReference));
                continue;
            }
            refs.addAll(Arrays.asList(new FileReferenceSet(url, element, offset, this, false).getAllReferences()));
        }
        if ((psiReferenceArray = refs.toArray(new PsiReference[refs.size()])) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getReferencesByElement must not return null");
        return psiReferenceArray;
    }

    public static int getPrefixLength(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider.getPrefixLength must not be null");
        }
        if (s.startsWith("urn:jsptagdir:")) {
            return "urn:jsptagdir:".length();
        }
        if (s.startsWith(FILE)) {
            return FILE.length();
        }
        if (s.startsWith(CLASSPATH)) {
            return CLASSPATH.length();
        }
        return 0;
    }

    static boolean isUrlText(String s, Project project) {
        boolean surelyUrl;
        boolean bl = surelyUrl = s.startsWith(HTTP) || s.startsWith(URN);
        if (surelyUrl) {
            return surelyUrl;
        }
        int protocolIndex = s.indexOf(":/");
        if (protocolIndex > 1 && !s.regionMatches(0, "classpath", 0, protocolIndex)) {
            return true;
        }
        return ExternalResourceManager.getInstance().getResourceLocation(s, project) != s;
    }

    private static URLReference[] getUrlReference(PsiElement element, boolean soft) {
        return new URLReference[]{new URLReference(element, null, soft)};
    }

    public static class DependentNSReference
    extends BasicAttributeValueReference
    implements QuickFixProvider {
        private final URLReference myReference;

        public DependentNSReference(PsiElement element, TextRange range, URLReference ref) {
            super(element, range);
            this.myReference = ref;
        }

        @Nullable
        public PsiFile resolveResource() {
            String canonicalText = this.getCanonicalText();
            return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getContainingFile(), null);
        }

        @Nullable
        public PsiElement resolve() {
            PsiFile file = this.resolveResource();
            if (file != null) {
                return file;
            }
            return this.myReference.resolve();
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider$DependentNSReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        public void registerQuickfix(HighlightInfo info, PsiReference reference) {
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)new FetchExtResourceAction());
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)new ManuallySetupExtResourceAction());
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)new IgnoreExtResourceAction());
        }
    }
}

