/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.ASTDiffBuilder;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project) {
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(Document doc) {
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            }
        });
    }

    @Override
    public void reparseRange(PsiFile file, int startOffset, int endOffset, CharSequence newTextS) throws IncorrectOperationException {
        LOG.assertTrue(file.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newTextS);
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
    }

    @Override
    public void reparseRange(final PsiFile file, final int startOffset, final int endOffset, final int lengthShift, final CharSequence newFileText) {
        file.getManager().performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                BlockSupportImpl.reparseRangeInternal(file, startOffset > 0 ? startOffset - 1 : 0, endOffset, lengthShift, newFileText);
            }
        });
    }

    private static void reparseRangeInternal(PsiFile file, int startOffset, int endOffset, int lengthShift, CharSequence newFileText) {
        FileElement node;
        file.getViewProvider().beforeContentsSynchronized();
        PsiFileImpl fileImpl = (PsiFileImpl)file;
        Project project = fileImpl.getProject();
        CharTable charTable = fileImpl.getTreeElement().getCharTable();
        int textLength = file.getTextLength() + lengthShift;
        FileElement treeFileElement = fileImpl.getTreeElement();
        if (treeFileElement.getElementType() instanceof ITemplateDataElementType) {
            BlockSupportImpl.makeFullParse(treeFileElement, newFileText, textLength, fileImpl);
            return;
        }
        LeafElement leafAtStart = treeFileElement.findLeafElementAt(startOffset);
        LeafElement leafAtEnd = treeFileElement.findLeafElementAt(endOffset);
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        for (node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : treeFileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            CharSequence newTextStr;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (reparseable.getLanguage() != baseLanguage || !reparseable.isParsable(newTextStr = newFileText.subSequence(textRange.getStartOffset(), textRange.getStartOffset() + textRange.getLength() + lengthShift), project) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(fileImpl.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            BlockSupportImpl.mergeTrees(fileImpl, node, chameleon);
            return;
        }
        BlockSupportImpl.makeFullParse(node, newFileText, textLength, fileImpl);
    }

    private static boolean hasErrorElementChild(ASTNode element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiErrorElement) {
            return true;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean optimizeLeafChange(FileElement treeFileElement, CharSequence newFileText, int startOffset, int endOffset, int lengthDiff, int changedOffset) {
        LeafElement leafElement = treeFileElement.findLeafElementAt(startOffset);
        if (leafElement == null || BlockSupportImpl.hasErrorElementChild(leafElement.getTreeParent()) || BlockSupportImpl.hasErrorElementChild(leafElement.getTreeNext()) || BlockSupportImpl.hasErrorElementChild(leafElement.getTreePrev())) {
            return false;
        }
        if (!leafElement.getTextRange().containsRange(startOffset, endOffset)) {
            return false;
        }
        LeafElement leafElementToChange = treeFileElement.findLeafElementAt(changedOffset);
        if (leafElementToChange == null) {
            return false;
        }
        TextRange leafRangeToChange = leafElementToChange.getTextRange();
        LeafElement newElement = ASTFactory.leaf(leafElementToChange.getElementType(), treeFileElement.getCharTable().intern(newFileText, leafRangeToChange.getStartOffset(), leafRangeToChange.getEndOffset() + lengthDiff));
        newElement.putUserData(CharTable.CHAR_TABLE_KEY, treeFileElement.getCharTable());
        leafElementToChange.getTreeParent().replaceChild(leafElementToChange, newElement);
        return true;
    }

    private static void makeFullParse(ASTNode parent, CharSequence newFileText, int textLength, PsiFileImpl fileImpl) {
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), null).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, textLength)));
            BlockSupportImpl.replaceFileElement(fileImpl, (FileElement)parent, (FileElement)holderElement.getFirstChildNode(), (PsiManagerEx)fileImpl.getManager());
        } else {
            FileViewProvider viewProvider = fileImpl.getViewProvider();
            FileType fileType = viewProvider.getVirtualFile().getFileType();
            LightVirtualFile lightFile = new LightVirtualFile(fileImpl.getName(), fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getModificationStamp());
            FileViewProvider copy = viewProvider.createCopy(lightFile);
            PsiFileImpl newFile = (PsiFileImpl)copy.getPsi(fileImpl.getLanguage());
            if (newFile == null) {
                LOG.error("View provider " + viewProvider + " refused to parse text with " + fileImpl.getLanguage() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + copy.getBaseLanguage() + "; fileType: " + fileType);
                return;
            }
            newFile.setOriginalFile(fileImpl);
            FileElement newFileElement = (FileElement)newFile.getNode();
            FileElement oldFileElement = (FileElement)fileImpl.getNode();
            Boolean data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY);
            if (data != null) {
                fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
            }
            if (data != null && data.booleanValue()) {
                BlockSupportImpl.replaceFileElementWithEvents(fileImpl, oldFileElement, newFileElement);
            } else {
                BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement);
            }
            ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider((VirtualFile)lightFile, null);
        }
    }

    private static void replaceFileElementWithEvents(PsiFileImpl fileImpl, FileElement fileElement, FileElement newFileElement) {
        fileImpl.getTreeElement().setCharTable(newFileElement.getCharTable());
        fileElement.replaceAllChildrenToChildrenOf(newFileElement);
    }

    static void replaceFileElement(PsiFileImpl fileImpl, FileElement fileElement, FileElement newFileElement, PsiManagerEx manager) {
        TreeElement firstChildNode;
        int oldLength = fileElement.getTextLength();
        BlockSupportImpl.sendPsiBeforeEvent(fileImpl);
        if (fileElement.getFirstChildNode() != null) {
            fileElement.rawRemoveAllChildren();
        }
        if ((firstChildNode = newFileElement.getFirstChildNode()) != null) {
            fileElement.rawAddChildren(firstChildNode);
        }
        fileImpl.getTreeElement().setCharTable(newFileElement.getCharTable());
        manager.invalidateFile(fileImpl);
        fileElement.subtreeChanged();
        BlockSupportImpl.sendPsiAfterEvent(fileImpl, oldLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeTrees(final @NotNull PsiFileImpl file, final @NotNull ASTNode oldRoot, final @NotNull ASTNode newRoot) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
        }
        if (oldRoot == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
        }
        if (newRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (newRoot instanceof FileElement) {
                ((FileElement)newRoot).setCharTable(file.getTreeElement().getCharTable());
            }
            final PomModel model = PomManager.getModel((Project)file.getProject());
            try {
                newRoot.putUserData(TREE_TO_BE_REPARSED, (Object)oldRoot);
                try {
                    newRoot.getFirstChildNode();
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    ((PsiManagerEx)file.getManager()).invalidateFile(file);
                    return;
                }
                TreeUtil.ensureParsedRecursively(oldRoot);
                model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file, model.getModelAspect(TreeAspect.class)){

                    public PomModelEvent runInner() {
                        ASTDiffBuilder builder = new ASTDiffBuilder(file);
                        DiffTree.diff((FlyweightCapableTreeStructure)new ASTStructure(oldRoot), (FlyweightCapableTreeStructure)new ASTStructure(newRoot), (ShallowNodeComparator)new ASTShallowComparator(), (DiffTreeChangeBuilder)builder);
                        file.subtreeChanged();
                        return new TreeAspectEvent(model, (TreeChangeEvent)builder.getEvent());
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            catch (Throwable th) {
                LOG.error(th);
            }
            finally {
                ((PsiManagerEx)file.getManager()).invalidateFile(file);
            }
        }
    }

    private static void sendPsiAfterEvent(PsiFileImpl scope, int oldLength) {
        if (!scope.isPhysical()) {
            return;
        }
        PsiManagerImpl manager = (PsiManagerImpl)scope.getManager();
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent((PsiElement)scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        manager.childrenChanged(event);
    }

    private static void sendPsiBeforeEvent(PsiFile scope) {
        if (!scope.isPhysical()) {
            return;
        }
        PsiManagerImpl manager = (PsiManagerImpl)scope.getManager();
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent((PsiElement)scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(scope.getTextLength());
        manager.beforeChildrenChange(event);
    }
}

