/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends ExpressionPsiElement
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
Constants {
    @NonNls
    private static final String QUOT = "&quot;";
    @NonNls
    private static final String HEXPREFIX = "0x";
    @NonNls
    private static final String HEXPREFIX2 = "0X";
    @NonNls
    private static final String LHEX_PREFIX = "0xl";
    @NonNls
    private static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);
    @NonNls
    private static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    private static final String _2_IN_63_L = _2_IN_63 + "l";

    public PsiLiteralExpressionImpl() {
        super(LITERAL_EXPRESSION);
    }

    public PsiType getType() {
        IElementType i = this.getFirstChildNode().getElementType();
        if (i == INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (i == LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (i == FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (i == DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (i == CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (i == STRING_LITERAL) {
            return PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        if (i == TRUE_KEYWORD || i == FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (i == NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public Object getValue() {
        String text = this.getFirstChildNode().getText();
        int textLength = text.length();
        IElementType i = this.getFirstChildNode().getElementType();
        if (i == INTEGER_LITERAL) {
            try {
                if (text.startsWith(HEXPREFIX) || text.startsWith(HEXPREFIX2)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 32);
                    return (int)value;
                }
                if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text, 3, 32);
                    return (int)value;
                }
                long l = Long.parseLong(text, 10);
                if (text.equals(_2_IN_31)) {
                    return (int)l;
                }
                long converted = (int)l;
                return l == converted ? Integer.valueOf((int)l) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (i == LONG_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text, (char)'L') || StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
                text = text.substring(0, textLength - 1);
            }
            try {
                if (text.startsWith(HEXPREFIX) || text.startsWith(HEXPREFIX2)) {
                    return PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 64);
                }
                if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                    return PsiLiteralExpressionImpl.parseDigits(text, 3, 64);
                }
                if (_2_IN_63.equals(text)) {
                    return Long.MIN_VALUE;
                }
                return Long.valueOf(text, 10);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (i == FLOAT_LITERAL) {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (i == DOUBLE_LITERAL) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (i == CHARACTER_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                if (textLength == 1) {
                    return null;
                }
                text = text.substring(1, textLength - 1);
            } else {
                text = text.substring(1, textLength);
            }
            StringBuilder chars = new StringBuilder();
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text, chars, null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        if (i == STRING_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
                if (textLength == 1) {
                    return null;
                }
                text = text.substring(1, textLength - 1);
            } else if (text.startsWith(QUOT) && text.endsWith(QUOT) && textLength > QUOT.length()) {
                text = text.substring(QUOT.length(), textLength - QUOT.length());
            } else {
                return null;
            }
            return PsiLiteralExpressionImpl.internedParseStringCharacters(text);
        }
        if (i == TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (i == FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (i == NULL_KEYWORD) {
            return null;
        }
        return null;
    }

    private static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    public String getParsingError() {
        Number number;
        Object value = this.getValue();
        TreeElement firstChildNode = this.getFirstChildNode();
        String text = firstChildNode.getText();
        IElementType i = firstChildNode.getElementType();
        if (i == INTEGER_LITERAL) {
            if (!(text = text.toLowerCase()).equals(_2_IN_31) || !(this.getParent() instanceof PsiPrefixExpression) || ((PsiPrefixExpression)this.getParent()).getOperationSign().getTokenType() != MINUS) {
                if (text.equals(HEXPREFIX)) {
                    return JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                }
                if (value == null || text.equals(_2_IN_31)) {
                    return JavaErrorMessages.message("integer.number.too.large", new Object[0]);
                }
            }
        } else if (i == LONG_LITERAL) {
            if (!(text = text.toLowerCase()).equals(_2_IN_63_L) || !(this.getParent() instanceof PsiPrefixExpression) || ((PsiPrefixExpression)this.getParent()).getOperationSign().getTokenType() != MINUS) {
                if (text.equals(HEXPREFIX) || text.equals(LHEX_PREFIX)) {
                    return JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                }
                if (value == null || text.equals(_2_IN_63_L)) {
                    return JavaErrorMessages.message("long.number.too.large", new Object[0]);
                }
            }
        } else if (i == FLOAT_LITERAL || i == DOUBLE_LITERAL) {
            if (value == null) {
                return JavaErrorMessages.message("malformed.floating.point.literal", new Object[0]);
            }
        } else if (i != TRUE_KEYWORD && i != FALSE_KEYWORD && i != NULL_KEYWORD) {
            StringBuilder chars;
            if (i == CHARACTER_LITERAL) {
                if (value == null) {
                    if (!StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        return null;
                    }
                    if (StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                        if (text.length() == 1) {
                            return JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                        }
                    } else {
                        return JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                    }
                    text = text.substring(1, text.length() - 1);
                    chars = new StringBuilder();
                    boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text, chars, null);
                    if (!success) {
                        return JavaErrorMessages.message("illegal.escape.character.in.character.literal", new Object[0]);
                    }
                    if (chars.length() > 1) {
                        return JavaErrorMessages.message("too.many.characters.in.character.literal", new Object[0]);
                    }
                    if (chars.length() == 0) {
                        return JavaErrorMessages.message("empty.character.literal", new Object[0]);
                    }
                }
            } else if (i == STRING_LITERAL && value == null) {
                for (PsiElement element : this.getChildren()) {
                    if (!(element instanceof OuterLanguageElement)) continue;
                    return null;
                }
                if (!StringUtil.startsWithChar((CharSequence)text, (char)'\"')) {
                    return null;
                }
                if (StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
                    if (text.length() == 1) {
                        return JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                    }
                } else {
                    return JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                }
                text = text.substring(1, text.length() - 1);
                chars = new StringBuilder();
                boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text, chars, null);
                if (!success) {
                    return JavaErrorMessages.message("illegal.escape.character.in.string.literal", new Object[0]);
                }
            }
        }
        if (value instanceof Float) {
            number = (Float)value;
            if (((Float)number).isInfinite()) {
                return JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
            }
            if (((Float)number).floatValue() == 0.0f && !this.isFPZero()) {
                return JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
            }
        }
        if (value instanceof Double) {
            number = (Double)value;
            if (((Double)number).isInfinite()) {
                return JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
            }
            if ((Double)number == 0.0 && !this.isFPZero()) {
                return JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
            }
        }
        return null;
    }

    private boolean isFPZero() {
        String text = this.getFirstChildNode().getText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            if (Character.toUpperCase(c) == 'E') break;
        }
        return true;
    }

    private static String internedParseStringCharacters(String chars) {
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.parseStringCharacters must not be null");
        }
        if (outChars == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.parseStringCharacters must not be null");
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\"': {
                    outChars.append('\"');
                    break;
                }
                case '\'': {
                    outChars.append('\'');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    if (index + 4 <= chars.length()) {
                        try {
                            int v = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (v == 10 || v == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)v);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLiteralExpression((PsiLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(this, PsiLiteralExpression.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Nullable
    public List<Pair<PsiElement, TextRange>> getInjectedPsi() {
        if (!(this.getValue() instanceof String)) {
            return null;
        }
        return InjectedLanguageUtil.getInjectedPsiFiles(this);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.updateText must not be null");
        }
        TreeElement valueNode = this.getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        StringLiteralEscaper stringLiteralEscaper = new StringLiteralEscaper(this);
        if (stringLiteralEscaper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.createLiteralTextEscaper must not return null");
        }
        return stringLiteralEscaper;
    }

    public void processInjectedPsi(@NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl.processInjectedPsi must not be null");
        }
        InjectedLanguageUtil.enumerate(this, visitor);
    }
}

