/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl");
    @NonNls
    private static final String GET_CLASS_METHOD = "getClass";
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.resolveMethodGenerics must not return null");
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.removeChild must not be null");
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceParameterList psiReferenceParameterList;
        PsiReferenceExpression expression = this.getMethodExpression();
        PsiReferenceParameterList result = expression.getParameterList();
        if (result != null) {
            psiReferenceParameterList = result;
            if (psiReferenceParameterList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArgumentList must not return null");
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString((PsiElement)expression, false));
        psiReferenceParameterList = result;
        if (psiReferenceParameterList != null) return psiReferenceParameterList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArgumentList must not return null");
    }

    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArguments must not return null");
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getMethodExpression must not return null");
        }
        return psiReferenceExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList psiExpressionList;
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list != null) {
            psiExpressionList = list;
            if (psiExpressionList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getArgumentList must not return null");
            return psiExpressionList;
        }
        LOG.error("Invalid PSI. Children:" + DebugUtil.psiToString(this, false));
        psiExpressionList = list;
        if (psiExpressionList != null) return psiExpressionList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getArgumentList must not return null");
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodCallExpression((PsiMethodCallExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Nullable
        public PsiType fun(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiType theOnly = null;
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            for (int i = 0; i < results.length; ++i) {
                PsiType type = TypeEvaluator.getResultType((PsiExpression)call, methodExpression, results[i]);
                if (type == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type;
                    continue;
                }
                if (theOnly.equals(type)) continue;
                return null;
            }
            return theOnly;
        }

        @Nullable
        private static PsiType getResultType(PsiExpression call, PsiReferenceExpression methodExpression, JavaResolveResult result) {
            PsiType ret;
            boolean is15OrHigher;
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiManager manager = call.getManager();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)call);
            boolean bl = is15OrHigher = languageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0;
            if (is15OrHigher && PsiMethodCallExpressionImpl.GET_CLASS_METHOD.equals(method.getName()) && "java.lang.Object".equals(method.getContainingClass().getQualifiedName())) {
                PsiClass javaLangClass;
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                PsiType qualifierType = null;
                if (qualifier != null) {
                    qualifierType = TypeConversionUtil.erasure((PsiType)qualifier.getType());
                } else {
                    ASTNode parent;
                    for (parent = call.getNode().getTreeParent(); parent != null && parent.getElementType() != JavaElementType.CLASS; parent = parent.getTreeParent()) {
                    }
                    if (parent != null) {
                        qualifierType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType((PsiClass)parent.getPsi());
                    }
                }
                if (qualifierType != null && (javaLangClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Class", call.getResolveScope())) != null && javaLangClass.getTypeParameters().length == 1) {
                    HashMap map = new HashMap();
                    map.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)qualifierType));
                    PsiSubstitutor substitutor = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createSubstitutor((Map)map);
                    return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(javaLangClass, substitutor, languageLevel);
                }
            }
            if ((ret = method.getReturnType()) == null) {
                return null;
            }
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
                    return TypeConversionUtil.erasure((PsiType)ret);
                }
                PsiType substitutedReturnType = substitutor.substitute(ret);
                return PsiImplUtil.normalizeWildcardTypeByPosition(substitutedReturnType, call);
            }
            return TypeConversionUtil.erasure((PsiType)ret);
        }
    }
}

