/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiNameValuePairImpl
extends CompositePsiElement
implements PsiNameValuePair,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");
    private volatile String myCachedName = null;
    private volatile PsiIdentifier myCachedNameIdentifier = null;
    private volatile PsiAnnotationMemberValue myCachedValue = null;
    private volatile boolean myNameCached = false;

    @Override
    public void clearCaches() {
        this.myNameCached = false;
        this.myCachedName = null;
        this.myCachedNameIdentifier = null;
        this.myCachedValue = null;
        super.clearCaches();
    }

    public PsiNameValuePairImpl() {
        super(NAME_VALUE_PAIR);
    }

    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier cachedNameIdentifier = this.myCachedNameIdentifier;
        if (!this.myNameCached) {
            this.myCachedNameIdentifier = cachedNameIdentifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(9);
            this.myCachedName = cachedNameIdentifier == null ? null : cachedNameIdentifier.getText();
            this.myNameCached = true;
        }
        return cachedNameIdentifier;
    }

    @Override
    public String getName() {
        String cachedName = this.myCachedName;
        if (!this.myNameCached) {
            PsiIdentifier identifier;
            this.myCachedNameIdentifier = identifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(9);
            cachedName = identifier == null ? null : identifier.getText();
            this.myCachedName = cachedName;
            this.myNameCached = true;
        }
        return cachedName;
    }

    public PsiAnnotationMemberValue getValue() {
        PsiAnnotationMemberValue cachedValue = this.myCachedValue;
        if (cachedValue == null) {
            this.myCachedValue = cachedValue = (PsiAnnotationMemberValue)this.findChildByRoleAsPsiElement(249);
        }
        return cachedValue;
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.setValue must not be null");
        }
        this.getValue().replace((PsiElement)newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.setValue must not return null");
        }
        return psiAnnotationMemberValue;
    }

    @Override
    public int getChildRole(ASTNode child) {
        if (ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getElementType())) {
            return 249;
        }
        if (child.getElementType() == IDENTIFIER) {
            return 9;
        }
        if (child.getElementType() == EQ) {
            return 63;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        if (role == 9) {
            return this.findChildByType(IDENTIFIER);
        }
        if (role == 249) {
            return this.findChildByType(ANNOTATION_MEMBER_VALUE_BIT_SET);
        }
        if (role == 63) {
            return this.findChildByType(EQ);
        }
        return null;
    }

    @Override
    public String toString() {
        return "PsiNameValuePair";
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                return nameRef == null ? null : (PsiClass)nameRef.resolve();
            }

            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    return nameIdentifier;
                }
                return PsiNameValuePairImpl.this;
            }

            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    return new TextRange(0, id.getTextLength());
                }
                return new TextRange(0, 0);
            }

            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature((PsiClass)refClass, (MethodSignature)signature, (boolean)false);
            }

            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                return name != null ? name : "value";
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName((PsiElement)nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getFirstChildNode().getElementType())) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore((PsiElement)nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1.bindToElement must not be null");
                }
                throw new IncorrectOperationException("Not implemented");
            }

            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1.getVariants must not return null");
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair((PsiNameValuePair)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        TreeElement treeElement = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == ElementType.IDENTIFIER) {
            LeafElement eq = Factory.createSingleLeafElement(ElementType.EQ, "=", 0, 1, treeCharTab, this.getManager());
            super.addInternal(eq, eq, first, Boolean.FALSE);
        }
        return treeElement;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.deleteChildInternal must not be null");
        }
        super.deleteChildInternal(child);
        if (child.getElementType() == JavaTokenType.IDENTIFIER) {
            super.deleteChildInternal(this.findChildByRole(63));
        }
    }
}

