/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeCastExpressionImpl
extends ExpressionPsiElement
implements PsiTypeCastExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiTypeCastExpressionImpl");

    public PsiTypeCastExpressionImpl() {
        super(TYPE_CAST_EXPRESSION);
    }

    public PsiTypeElement getCastType() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    public PsiExpression getOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(67);
    }

    @Nullable
    public PsiType getType() {
        PsiTypeElement castType = this.getCastType();
        if (castType == null) {
            return null;
        }
        return castType.getType();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 67: 
        }
        return this.findChildByType(EXPRESSION_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : "child:" + child + "; child.getTreeParent():" + child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == TYPE) {
            return 10;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTypeCastExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeCastExpression((PsiTypeCastExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiTypeCastExpression:" + this.getText();
    }
}

