/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubTree");
    private final PsiFileStub myRoot;
    private final List<StubElement<?>> myPlainList;

    public StubTree(@NotNull PsiFileStub root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubTree.<init> must not be null");
        }
        this.myPlainList = new ArrayList();
        this.myRoot = root;
        StubTree.enumerateStubs(root, this.myPlainList);
    }

    private static void enumerateStubs(StubElement<?> root, List<StubElement<?>> result) {
        ((StubBase)root).id = result.size();
        result.add(root);
        for (StubElement child : root.getChildrenStubs()) {
            StubTree.enumerateStubs(child, result);
        }
    }

    @NotNull
    public PsiFileStub getRoot() {
        PsiFileStub psiFileStub = this.myRoot;
        if (psiFileStub == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubTree.getRoot must not return null");
        }
        return psiFileStub;
    }

    public List<StubElement<?>> getPlainList() {
        return this.myPlainList;
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, TIntArrayList>> indexStubTree() {
        final HashMap<StubIndexKey, Map<Object, TIntArrayList>> result = new HashMap<StubIndexKey, Map<Object, TIntArrayList>>();
        int i = 0;
        while (i < this.myPlainList.size()) {
            StubElement<?> stub = this.myPlainList.get(i);
            StubSerializer serializer = SerializationManager.getInstance().getSerializer(stub);
            final int stubIdx = i++;
            serializer.indexStub(stub, new IndexSink(){

                public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value) {
                    TIntArrayList list;
                    if (indexKey == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubTree$1.occurrence must not be null");
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/StubTree$1.occurrence must not be null");
                    }
                    HashMap<Object, TIntArrayList> map = (HashMap<Object, TIntArrayList>)result.get(indexKey);
                    if (map == null) {
                        map = new HashMap<Object, TIntArrayList>();
                        result.put(indexKey, map);
                    }
                    if ((list = (TIntArrayList)map.get(value)) == null) {
                        list = new TIntArrayList();
                        map.put(value, list);
                    }
                    list.add(stubIdx);
                }
            });
        }
        HashMap<StubIndexKey, Map<Object, TIntArrayList>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubTree.indexStubTree must not return null");
        }
        return hashMap;
    }

    @Nullable
    public static StubTree readOrBuild(Project project, VirtualFile vFile) {
        StubTree fromIndices = StubTree.readFromVFile(project, vFile);
        if (fromIndices != null) {
            return fromIndices;
        }
        if (!StubUpdatingIndex.canHaveStub(vFile)) {
            return null;
        }
        try {
            FileContent fc = new FileContent(vFile, vFile.contentsToByteArray());
            fc.putUserData(FileBasedIndex.PROJECT, project);
            StubElement element = StubUpdatingIndex.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Nullable
    public static StubTree readFromVFile(Project project, final VirtualFile vFile) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        int id = Math.abs(FileBasedIndex.getFileId(vFile));
        if (id > 0) {
            List<SerializedStubTree> datas = FileBasedIndex.getInstance().getValues(StubUpdatingIndex.INDEX_ID, id, GlobalSearchScope.fileScope((Project)project, (VirtualFile)vFile));
            int size = datas.size();
            if (size == 1) {
                StubElement stub = datas.get(0).getStub();
                return new StubTree((PsiFileStub)stub);
            }
            if (size != 0) {
                LOG.error("Twin stubs: " + vFile.getPresentableUrl() + " has " + size + " stub versions. Should only have one. id=" + id);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                        if (doc != null) {
                            FileDocumentManager.getInstance().saveDocument(doc);
                        }
                    }
                }, ModalityState.NON_MODAL);
                FileBasedIndex.getInstance().requestReindex(vFile);
            }
        }
        return null;
    }
}

