/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.lang.ElementsHandler;

public abstract class BaseExtractModuleAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        if (elements.length > 0) {
            Language language = elements[0].getLanguage();
            RefactoringActionHandler handler = ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(language)).getExtractModuleHandler();
            return this.isEnabledOnLanguage(language) && handler instanceof ElementsHandler && ((ElementsHandler)handler).isEnabledOnElements(elements);
        }
        return false;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        RefactoringSupportProvider supportProvider = (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage());
        return supportProvider != null ? supportProvider.getExtractModuleHandler() : null;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return this.isEnabledOnLanguage(language) && ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(language)).getExtractModuleHandler() != null;
    }

    protected abstract boolean isEnabledOnLanguage(Language var1);
}

