/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;

public class InvertBooleanAction
extends BaseRefactoringAction {
    @Override
    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && (elements[0] instanceof PsiMethod || elements[0] instanceof PsiVariable);
    }

    @Override
    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        if (element instanceof PsiVariable) {
            return PsiType.BOOLEAN.equals(((PsiVariable)element).getType());
        }
        if (element instanceof PsiMethod) {
            return PsiType.BOOLEAN.equals(((PsiMethod)element).getReturnType());
        }
        return false;
    }

    @Override
    protected RefactoringActionHandler getHandler(DataContext dataContext) {
        return new InvertBooleanHandler();
    }
}

