/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractParameterTablePanel;
import com.intellij.refactoring.extractMethod.AbstractVariableData;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbstractExtractMethodDialog
extends DialogWrapper
implements ExtractMethodSettings {
    private JPanel myContentPane;
    private AbstractParameterTablePanel myParametersPanel;
    private JTextField myMethodNameTextField;
    private JTextArea mySignaturePreviewTextArea;
    private JTextArea myOutputVariablesTextArea;
    private final String myDefaultName;
    private final ExtractMethodValidator myValidator;
    private final ExtractMethodDecorator myDecorator;
    private AbstractVariableData[] myVariableData;
    private Map<String, AbstractVariableData> myVariablesMap;
    private final List<String> myArguments;
    private final ArrayList<String> myOutputVariables;

    public AbstractExtractMethodDialog(Project project, String defaultName, CodeFragment fragment, ExtractMethodValidator validator, ExtractMethodDecorator decorator) {
        super(project, true);
        this.myDefaultName = defaultName;
        CodeFragment fragment1 = fragment;
        this.myValidator = validator;
        this.myDecorator = decorator;
        this.$$$setupUI$$$();
        this.myArguments = new ArrayList<String>(fragment1.getInputVariables());
        Collections.sort(this.myArguments);
        this.myOutputVariables = new ArrayList<String>(fragment1.getOutputVariables());
        Collections.sort(this.myOutputVariables);
        this.setModal(true);
        this.setTitle(RefactoringBundle.message((String)"extract.method.title"));
        this.init();
    }

    protected void init() {
        super.init();
        this.myMethodNameTextField.setText(this.myDefaultName);
        this.myMethodNameTextField.setSelectionStart(0);
        this.myMethodNameTextField.setSelectionStart(this.myDefaultName.length());
        this.myMethodNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                AbstractExtractMethodDialog.this.updateOutputVariables();
                AbstractExtractMethodDialog.this.updateSignature();
                AbstractExtractMethodDialog.this.updateOkStatus();
            }
        });
        this.myVariableData = AbstractExtractMethodDialog.createVariableData(this.myArguments);
        this.myVariablesMap = AbstractExtractMethodDialog.createVariableMap(this.myVariableData);
        this.myParametersPanel.setVariableData(this.myVariableData);
        this.myParametersPanel.init();
        this.updateOutputVariables();
        this.updateSignature();
        this.updateOkStatus();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMethodNameTextField;
    }

    public static AbstractVariableData[] createVariableData(List<String> args) {
        AbstractVariableData[] datas = new AbstractVariableData[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            String name;
            AbstractVariableData data = new AbstractVariableData();
            data.originalName = name = args.get(i);
            data.name = name;
            data.passAsParameter = true;
            datas[i] = data;
        }
        return datas;
    }

    public static Map<String, AbstractVariableData> createVariableMap(AbstractVariableData[] data) {
        HashMap map = new HashMap();
        for (AbstractVariableData variableData : data) {
            map.put((Object)variableData.getOriginalName(), (Object)variableData);
        }
        return map;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doOKAction() {
        String error = this.myValidator.check(this.getMethodName());
        if (error != null) {
            Messages.showInfoMessage((String)error, (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        super.doOKAction();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.extractMethod");
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myParametersPanel = new AbstractParameterTablePanel(this.myValidator){

            @Override
            protected void doCancelAction() {
                AbstractExtractMethodDialog.this.doCancelAction();
            }

            @Override
            protected void doEnterAction() {
                AbstractExtractMethodDialog.this.doOKAction();
            }

            @Override
            protected void updateSignature() {
                AbstractExtractMethodDialog.this.updateOutputVariables();
                AbstractExtractMethodDialog.this.updateSignature();
            }
        };
    }

    private void updateOutputVariables() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String variable : this.myOutputVariables) {
            String outputName;
            if (this.myVariablesMap == null) continue;
            AbstractVariableData data = this.myVariablesMap.get(variable);
            String string = outputName = data != null ? data.getName() : variable;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(outputName);
        }
        this.myOutputVariablesTextArea.setText(builder.length() > 0 ? builder.toString() : RefactoringBundle.message((String)"refactoring.extract.method.dialog.empty"));
    }

    private void updateSignature() {
        this.mySignaturePreviewTextArea.setText(this.myDecorator.createMethodPreview(this.getMethodName(), this.myVariableData));
    }

    private void updateOkStatus() {
        this.setOKActionEnabled(this.myValidator.isValidName(this.getMethodName()));
    }

    @Override
    public String getMethodName() {
        return this.myMethodNameTextField.getText().trim();
    }

    @Override
    public AbstractVariableData[] getVariableData() {
        return this.myVariableData;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextArea jTextArea2;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        this.myMethodNameTextField = jTextField = new JTextField();
        jTextField.setColumns(10);
        jTextField.setHorizontalAlignment(2);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 1, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("refactoring.extract.method.dialog.method.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/RefactoringBundle").getString("refactoring.extract.method.dialog.parameters"), 0, 0, null, null));
        AbstractParameterTablePanel abstractParameterTablePanel = this.myParametersPanel;
        jPanel3.add((Component)abstractParameterTablePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        this.mySignaturePreviewTextArea = jTextArea2 = new JTextArea();
        ((Component)jTextArea2).setEnabled(true);
        jTextArea2.setRows(0);
        jTextArea2.setColumns(10);
        jTextArea2.setText("def foo()");
        jTextArea2.setEditable(false);
        jScrollPane.setViewportView(jTextArea2);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("refactoring.extract.method.dialog.signature.preview"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel.add((Component)jScrollPane2, new GridConstraints(5, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        this.myOutputVariablesTextArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("refactoring.extract.method.dialog.output.variables"));
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

