/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.PsiExpressionTrimRenderer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractMethod.ExtractMethodHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.method.title");

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ExtractMethodHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethod/ExtractMethodHandler.invoke must not be null");
        }
        if (dataContext != null) {
            PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
            if (file != null && editor != null) {
                ExtractMethodHandler.invokeOnElements(project, editor, file, elements);
            }
        }
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractMethod/ExtractMethodHandler.invoke must not be null");
        }
        Pass<PsiElement[]> callback = new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodHandler.invokeOnElements(project, editor, file, selectedValue);
            }
        };
        ExtractMethodHandler.selectAndPass(project, editor, file, callback);
    }

    public static void selectAndPass(Project project, Editor editor, PsiFile file, final Pass<PsiElement[]> callback) {
        PsiElement[] elements;
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            PsiElement[] statementsInRange;
            int offset = editor.getCaretModel().getOffset();
            List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file, editor, offset, statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file, offset));
            if (expressions.size() < 2) {
                editor.getSelectionModel().selectLineAtCaret();
            } else {
                IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                    public void pass(PsiExpression psiExpression) {
                        callback.pass((Object)new PsiElement[]{psiExpression});
                    }
                }, new PsiExpressionTrimRenderer.RenderFunction());
                return;
            }
        }
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiExpression expr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (expr != null) {
            elements = new PsiElement[]{expr};
        } else {
            PsiType originalType;
            PsiExpression expression;
            elements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
            if (elements.length == 0 && (expression = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset)) != null && (originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expression)) != null) {
                elements = new PsiElement[]{expression};
            }
        }
        callback.pass((Object)elements);
    }

    private static void invokeOnElements(Project project, Editor editor, PsiFile file, PsiElement[] elements) {
        ExtractMethodProcessor processor = ExtractMethodHandler.getProcessor(elements, project, file, editor, true);
        if (processor != null) {
            ExtractMethodHandler.invokeOnElements(project, editor, processor, true);
        }
    }

    private static boolean invokeOnElements(final Project project, final Editor editor, final @NotNull ExtractMethodProcessor processor, boolean directTypes) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/extractMethod/ExtractMethodHandler.invokeOnElements must not be null");
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)processor.getTargetClass().getContainingFile())) {
            return false;
        }
        if (processor.showDialog(directTypes)) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        processor.doRefactoring();
                                    }
                                    catch (IncorrectOperationException e) {
                                        LOG.error((Throwable)e);
                                    }
                                }
                            });
                            DuplicatesImpl.processDuplicates(processor, project, editor);
                        }
                    });
                }
            }, REFACTORING_NAME, null);
            return true;
        }
        return false;
    }

    @Nullable
    private static ExtractMethodProcessor getProcessor(PsiElement[] elements, Project project, PsiFile file, Editor editor, boolean showErrorMessages) {
        if (elements == null || elements.length == 0) {
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return null;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiStatement) || !RefactoringUtil.isSuperOrThisCall((PsiStatement)element, true, true)) continue;
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.contains.invocation.of.another.class.constructor"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return null;
        }
        ExtractMethodProcessor processor = new ExtractMethodProcessor(project, editor, elements, null, REFACTORING_NAME, "", "refactoring.extractMethod");
        processor.setShowErrorDialogs(showErrorMessages);
        try {
            if (!processor.prepare()) {
                return null;
            }
        }
        catch (PrepareFailedException e) {
            if (showErrorMessages) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
                ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            }
            return null;
        }
        return processor;
    }

    public static void highlightPrepareError(PrepareFailedException e, PsiFile file, Editor editor, Project project) {
        if (e.getFile() == file) {
            TextRange textRange = e.getTextRange();
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, null);
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
            editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    @Nullable
    public static ExtractMethodProcessor getProcessor(Project project, PsiElement[] elements, PsiFile file, boolean openEditor) {
        return ExtractMethodHandler.getProcessor(elements, project, file, openEditor ? ExtractMethodHandler.openEditor(project, file) : null, false);
    }

    public static boolean invokeOnElements(Project project, @NotNull ExtractMethodProcessor processor, PsiFile file, boolean directTypes) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractMethod/ExtractMethodHandler.invokeOnElements must not be null");
        }
        return ExtractMethodHandler.invokeOnElements(project, ExtractMethodHandler.openEditor(project, file), processor, directTypes);
    }

    @Nullable
    private static Editor openEditor(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile);
        return FileEditorManager.getInstance((Project)project).openTextEditor(fileDescriptor, false);
    }
}

