/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceThisCallWithDelegateCall
extends FixableUsageInfo {
    private final String delegateFieldName;
    private final PsiMethodCallExpression call;

    public ReplaceThisCallWithDelegateCall(PsiMethodCallExpression call, String delegateFieldName) {
        super((PsiElement)call);
        this.call = call;
        this.delegateFieldName = delegateFieldName;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiReferenceExpression methodExpression = this.call.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null) {
            MutationUtils.replaceExpression(this.delegateFieldName + '.' + this.call.getText(), (PsiExpression)this.call);
        } else {
            MutationUtils.replaceExpression(this.delegateFieldName, qualifierExpression);
        }
    }
}

