/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineLocalHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineLocalHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.variable.title");

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiLocalVariable;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtilBase.findReference(editor);
        PsiReferenceExpression refExpr = psiReference instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiReference : null;
        InlineLocalHandler.invoke(project, editor, (PsiLocalVariable)element, refExpr);
    }

    public static void invoke(@NotNull Project project, Editor editor, PsiLocalVariable local, PsiReferenceExpression refExpr) {
        PsiExpression defToInline;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inline/InlineLocalHandler.invoke must not be null");
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        Query query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false);
        if (query.findFirst() == null) {
            LOG.assertTrue(refExpr == null);
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        final PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)local, PsiClass.class);
        final ArrayList innerClassesWithUsages = new ArrayList();
        final ArrayList innerClassUsages = new ArrayList();
        query.forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                PsiElement element = psiReference.getElement();
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (psiClass != containingClass) {
                    innerClassesWithUsages.add(psiClass);
                    innerClassUsages.add(element);
                }
                return true;
            }
        });
        PsiCodeBlock containerBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
        LOG.assertTrue(containerBlock != null);
        PsiExpression psiExpression = defToInline = innerClassesWithUsages.isEmpty() ? InlineLocalHandler.getDefToInline(local, (PsiElement)refExpr, containerBlock) : InlineLocalHandler.getDefToInline(local, (PsiElement)innerClassesWithUsages.get(0), containerBlock);
        if (defToInline == null) {
            String key = refExpr == null ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        ArrayList<PsiElement> refsToInlineList = new ArrayList<PsiElement>();
        Collections.addAll(refsToInlineList, DefUseUtil.getRefs(containerBlock, (PsiVariable)local, (PsiElement)defToInline));
        for (PsiElement innerClassUsage : innerClassUsages) {
            if (refsToInlineList.contains(innerClassUsage)) continue;
            refsToInlineList.add(innerClassUsage);
        }
        if (refsToInlineList.size() == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used.before.modification", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        Object[] refsToInline = refsToInlineList.toArray(new PsiElement[refsToInlineList.size()]);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        if (refExpr != null && PsiUtil.isAccessedForReading((PsiExpression)refExpr) && ArrayUtil.find((Object[])refsToInline, (Object)refExpr) < 0) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)refExpr);
            LOG.assertTrue(defs.length > 0);
            highlightManager.addOccurrenceHighlights(editor, defs, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        PsiFile workingFile = local.getContainingFile();
        for (Object ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (otherFile.equals(workingFile)) continue;
            String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        for (Object ref : refsToInline) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)ref);
            boolean isSameDefinition = true;
            for (PsiElement def : defs) {
                isSameDefinition &= InlineLocalHandler.isSameDefinition(def, defToInline);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor, defs, writeAttributes, true, null);
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{ref}, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        if (InlineLocalHandler.checkRefsInAugmentedAssignment((PsiElement[])refsToInline, project, editor, localName)) {
            return;
        }
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])refsToInline, attributes, true, null);
            int occurrencesCount = refsToInline.length;
            String occurencesString = RefactoringBundle.message((String)"occurences.string", (Object[])new Object[]{occurrencesCount});
            String promptKey = InlineLocalHandler.isInliningVariableInitializer(defToInline) ? "inline.local.variable.prompt" : "inline.local.variable.definition.prompt";
            String question = RefactoringBundle.message((String)promptKey, (Object[])new Object[]{localName}) + " " + occurencesString;
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
            dialog.show();
            if (!dialog.isOK()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                return;
            }
        }
        final Runnable runnable = new Runnable((PsiElement[])refsToInline, local, defToInline, project, editor, highlightManager, attributes){
            final /* synthetic */ PsiElement[] val$refsToInline;
            final /* synthetic */ PsiLocalVariable val$local;
            final /* synthetic */ PsiExpression val$defToInline;
            final /* synthetic */ Project val$project;
            final /* synthetic */ Editor val$editor;
            final /* synthetic */ HighlightManager val$highlightManager;
            final /* synthetic */ TextAttributes val$attributes;
            {
                this.val$refsToInline = psiElementArray;
                this.val$local = psiLocalVariable;
                this.val$defToInline = psiExpression;
                this.val$project = project;
                this.val$editor = editor;
                this.val$highlightManager = highlightManager;
                this.val$attributes = textAttributes;
            }

            @Override
            public void run() {
                try {
                    PsiExpression[] exprs = new PsiExpression[this.val$refsToInline.length];
                    for (int idx = 0; idx < this.val$refsToInline.length; ++idx) {
                        PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)this.val$refsToInline[idx];
                        exprs[idx] = InlineUtil.inlineVariable((PsiVariable)this.val$local, this.val$defToInline, refElement);
                    }
                    if (!InlineLocalHandler.isInliningVariableInitializer(this.val$defToInline)) {
                        this.val$defToInline.getParent().delete();
                    } else {
                        this.val$defToInline.delete();
                    }
                    if (ReferencesSearch.search((PsiElement)this.val$local).findFirst() == null) {
                        QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)this.val$local).invoke(this.val$project, this.val$editor, this.val$local.getContainingFile());
                    }
                    if (this.val$editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                        this.val$highlightManager.addOccurrenceHighlights(this.val$editor, (PsiElement[])exprs, this.val$attributes, true, null);
                        WindowManager.getInstance().getStatusBar(this.val$project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    }
                    for (PsiExpression expr : exprs) {
                        InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    private static boolean checkRefsInAugmentedAssignment(PsiElement[] refsToInline, Project project, Editor editor, String localName) {
        for (PsiElement element : refsToInline) {
            PsiAssignmentExpression assignmentExpression;
            if (!(element.getParent() instanceof PsiAssignmentExpression) || element != (assignmentExpression = (PsiAssignmentExpression)element.getParent()).getLExpression()) continue;
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{element}, writeAttributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return true;
        }
        return false;
    }

    private static boolean isSameDefinition(PsiElement def, PsiExpression defToInline) {
        if (def instanceof PsiLocalVariable) {
            return defToInline.equals(((PsiLocalVariable)def).getInitializer());
        }
        PsiElement parent = def.getParent();
        return parent instanceof PsiAssignmentExpression && defToInline.equals(((PsiAssignmentExpression)parent).getRExpression());
    }

    private static boolean isInliningVariableInitializer(PsiExpression defToInline) {
        return defToInline.getParent() instanceof PsiVariable;
    }

    @Nullable
    private static PsiExpression getDefToInline(PsiLocalVariable local, PsiElement refExpr, PsiCodeBlock block) {
        if (refExpr != null) {
            PsiExpression rExpr;
            PsiElement def;
            if (refExpr instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refExpr))) {
                def = refExpr;
            } else {
                PsiElement[] defs = DefUseUtil.getDefs(block, (PsiVariable)local, refExpr);
                if (defs.length == 1) {
                    def = defs[0];
                } else {
                    return null;
                }
            }
            if (def instanceof PsiReferenceExpression && def.getParent() instanceof PsiAssignmentExpression && (rExpr = ((PsiAssignmentExpression)def.getParent()).getRExpression()) != null) {
                return rExpr;
            }
        }
        return local.getInitializer();
    }
}

